/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelactivities;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class BPELDataHandlingTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPELDataHandlingTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true, groups={"wso2.bps.bpelactivities"})
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestComposeUrl");
        this.uploadBpelForTest("FlexibleAssign");
        this.uploadBpelForTest("TestIgnoreMissingFromData");
        this.uploadBpelForTest("TestCombineUrl");
        this.uploadBpelForTest("TestExpandTemplate");
        this.uploadBpelForTest("TestAssignActivity1");
        this.uploadBpelForTest("TestAssignDate");
        this.uploadBpelForTest("TestXslTransform");
        this.uploadBpelForTest("TestCounter");
        this.uploadBpelForTest("TestSplit");
        this.uploadBpelForTest("XMLAttributeProcess");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "XMLAttributeProcessService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="this test will use composeUrl with the element argument")
    public void composeURLWithElement() throws XMLStreamException, AxisFault {
        String payload = "<un:composeUrl xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><template>http://example.com/{user}/{tag}/{a_missing_var}</template><name/><value/><pairs><user>bill</user><tag>ruby</tag></pairs></un:composeUrl>";
        String operation = "composeUrl";
        String serviceName = "TestComposeUrlService";
        String expectedOutput = "http://example.com/bill/ruby/";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="this test will use composeUrl with a list of name, value, name, value, etc")
    public void composeURL() throws XMLStreamException, AxisFault {
        String payload = "<un:composeUrl xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><template>http://example.com/{user}/{a_missing_var}</template><name>user</name><value>bill</value><pairs /></un:composeUrl>";
        String operation = "composeUrl";
        String serviceName = "TestComposeUrlService";
        String expectedOutput = "http://example.com/bill/";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    public void flexibleAssign() throws XMLStreamException, AxisFault {
        String payload = "<flex:typeA xmlns:flex=\"http://wso2.org/bps/schema/FlexibleAssign\"><flex:paramA>ee</flex:paramA></flex:typeA>";
        String operation = "operation1";
        String serviceName = "FlexibleAssign";
        String expectedOutput = "ee";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    public void ignoreMissingFromData() throws XMLStreamException, AxisFault {
        String payload = "<test:Input xmlns:test=\"test:test\">yy</test:Input>";
        String operation = "process";
        String serviceName = "TestIgnoreMissingFromDataService";
        String expectedOutput = "Test passed.";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="Combine URL on data handling test case")
    public void combineUrl() throws XMLStreamException, AxisFault {
        String payload = "<un:combineUrl xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><base>http://example.com/html/about.html</base><relative>../experts/</relative></un:combineUrl>";
        String operation = "combineUrl";
        String serviceName = "TestCombineUrlService";
        String expectedOutput = "http://example.com/experts/";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="expanding template with element")
    public void expandTemplateWithElement() throws XMLStreamException, AxisFault {
        String payload = "<un:expandTemplate xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><template>http://example.com/{user}/{tag}/{a_missing_var}/{another_missing_var=but_with_a_default}</template><name/><value/><pairs><user>bill</user><tag>ruby</tag></pairs></un:expandTemplate>";
        String operation = "expandTemplate";
        String serviceName = "TestExpandTemplateService";
        String expectedOutput = "http://example.com/bill/ruby/{a_missing_var}/but_with_a_default";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="expanding template")
    public void expandTemplate() throws XMLStreamException, AxisFault {
        String payload = "<un:expandTemplate xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><template>http://example.com/{user}/{a_missing_var}/{another_missing_var=but_with_a_default}</template><name>user</name><value>bill</value><pairs/></un:expandTemplate>";
        String operation = "expandTemplate";
        String serviceName = "TestExpandTemplateService";
        String expectedOutput = "http://example.com/bill/{a_missing_var}/but_with_a_default";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="assign activity in data handling test case")
    public void assignActivity1() throws XMLStreamException, AxisFault {
        String payload = "<un:testAssign xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><TestPart>Hello</TestPart></un:testAssign>";
        String operation = "testAssign";
        String serviceName = "TestAssignService";
        String expectedOutput = "Hello World7true3";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="assign activity in data handling test case")
    public void assignActivity2() throws XMLStreamException, AxisFault {
        String payload = "<un:testAssign xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><TestPart>Hello</TestPart></un:testAssign>";
        String operation = "testAssign";
        String serviceName = "TestAssignService";
        String expectedOutput = "Hello World7true3";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="assign data in data handling test case")
    public void assignDate() throws XMLStreamException, AxisFault {
        String payload = "<ns1:TaskRequest xmlns:ns1=\"http://example.com/NewDiagram/Pool\">start</ns1:TaskRequest>";
        String operation = "Task";
        String serviceName = "TestAssignDateService";
        String expectedOutput = "OK";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="XSLT transform in data handling test case")
    public void XSLTransform() throws XMLStreamException, AxisFault {
        String payload = "<un:helloXsl xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><TestPart><content>Hello</content></TestPart></un:helloXsl>";
        String operation = "helloXsl";
        String serviceName = "HelloXslService";
        String expectedOutput = "HelloXsl World";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="split in data handling test case")
    public void split() throws AxisFault, XMLStreamException {
        String payload = "<un:split xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><TestPart>split,me,this,please</TestPart></un:split>";
        String operation = "split";
        String serviceName = "TestSplitService";
        String expectedOutput = "<chunk>split</chunk><chunk>me</chunk><chunk>this</chunk><chunk>please</chunk>";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities", "wso2.bps.bpelactivities"}, description="counter in data handling test case")
    public void counter() throws AxisFault, XMLStreamException {
        String payload = "<un:initialize xmlns:un=\"http://example.com/bpel/counter\"><counterName>foo</counterName></un:initialize>";
        String operation = "initialize";
        String serviceName = "counterService";
        String expectedOutput = "10.0";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="test attribute manipulations in data handling test case")
    public void processProperty() throws Exception {
        String payload = "<p:XMLAttributeProcessRequest xmlns:p=\"http://eclipse.org/bpel/sample\">\n      <p:input>1</p:input>\n   </p:XMLAttributeProcessRequest>";
        String operation = "initiate";
        String serviceName = "XMLAttributeProcessService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("testUserIdAttribute=\"1\"");
        expectedOutput.add("testAttribute=\"testAttributeValue\"");
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestComposeUrl");
        this.bpelPackageManagementClient.undeployBPEL("FlexibleAssign");
        this.bpelPackageManagementClient.undeployBPEL("TestIgnoreMissingFromData");
        this.bpelPackageManagementClient.undeployBPEL("TestCombineUrl");
        this.bpelPackageManagementClient.undeployBPEL("TestExpandTemplate");
        this.bpelPackageManagementClient.undeployBPEL("TestAssignActivity1");
        this.bpelPackageManagementClient.undeployBPEL("TestAssignDate");
        this.bpelPackageManagementClient.undeployBPEL("TestXslTransform");
        this.bpelPackageManagementClient.undeployBPEL("TestCounter");
        this.bpelPackageManagementClient.undeployBPEL("TestSplit");
        this.bpelPackageManagementClient.undeployBPEL("TestXslTransform");
        this.bpelPackageManagementClient.undeployBPEL("XMLAttributeProcess");
        this.loginLogoutClient.logout();
    }
}

