/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelactivities;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class BPELRestInvocationTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPELRestInvocationTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true, groups={"wso2.bps.bpelactivities"})
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestRESTProcess");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "RestTestService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="Tests REST process invocation")
    public void InvokeRestService() throws Exception {
        try {
            String payload = "<p:testRest xmlns:p=\"http://ws.apache.org/axis2\"><issue>CARBON-9659</issue></p:testRest>";
            String operation = "testRest";
            String serviceName = "RestTestService";
            ArrayList<String> expectedOutput = new ArrayList<String>();
            expectedOutput.add("<link>https://wso2.org/jira/browse/CARBON-9659</link>");
            this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
        }
        catch (IOException e) {
            log.error((Object)"Internet connection is not available. Ignoring the external REST invocation...", (Throwable)e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestRESTProcess");
        this.loginLogoutClient.logout();
    }
}

