/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelmanagement;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.bpel.stub.mgt.ProcessManagementException;

public class BpelProcessManagementTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelProcessManagementTest.class);
    BpelPackageManagementClient bpelPackageManagementClient = null;
    BpelProcessManagementClient bpelProcessManagementClient = null;
    BpelInstanceManagementClient bpelInstanceManagementClient = null;
    RequestSender requestSender = null;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("LoanService");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "XKLoanService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.manage"}, description="Set process to retired State", priority=1, singleThreaded=true)
    public void testServiceRetire() throws ProcessManagementException, RemoteException {
        try {
            String processID = this.bpelProcessManagementClient.getProcessId("XKLoanService");
            this.bpelProcessManagementClient.setStatus(processID, "RETIRED");
            Thread.sleep(5000L);
            Assert.assertTrue((boolean)this.bpelProcessManagementClient.getStatus(processID).equals("RETIRED"), (String)"BPEL process is not set as RETIRED");
            Assert.assertFalse((boolean)this.requestSender.isServiceAvailable(this.backEndUrl + "XKLoanService"), (String)"Service is still available");
        }
        catch (InterruptedException e) {
            log.debug((Object)"Thread interrupted");
        }
    }

    @Test(groups={"wso2.bps", "wso2.bps.manage"}, description="Set service to Active State", dependsOnMethods={"testServiceRetire"}, singleThreaded=true)
    public void testServiceActive() throws ProcessManagementException, RemoteException {
        try {
            String processID = this.bpelProcessManagementClient.getProcessId("XKLoanService");
            this.bpelProcessManagementClient.setStatus(processID, "ACTIVE");
            Thread.sleep(5000L);
            Assert.assertTrue((boolean)this.bpelProcessManagementClient.getStatus(processID).equals("ACTIVE"), (String)"BPEL process is not set as ACTIVE");
            Assert.assertTrue((boolean)this.requestSender.isServiceAvailable(this.backEndUrl + "XKLoanService"), (String)"Service is not available");
        }
        catch (InterruptedException e) {
            log.error((Object)("Process management failed" + e));
            Assert.fail((String)("Process management failed" + e));
        }
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws Exception {
        this.bpelPackageManagementClient.undeployBPEL("LoanService");
        this.loginLogoutClient.logout();
    }
}

