/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.upload;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;

public class BpelRedeployTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelRedeployTest.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @Test(groups={"wso2.bps", "wso2.bps.deployment"}, description="Tests redeploy bpel", priority=0)
    public void testUplpad() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("HelloWorld2");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "HelloService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.deployment"}, description="Tests redeploy bpel", priority=1)
    public void testRedeploy() throws Exception {
        Thread.sleep(5000L);
        this.uploadBpelForTest("HelloWorld2");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "HelloService");
        this.bpelPackageManagementClient.checkProcessDeployment(0, "HelloWorld2");
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("HelloWorld2");
        this.loginLogoutClient.logout();
    }
}

