/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.upload;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;

public class BpelRetireDeploymentTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelRetireDeploymentTest.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("HelloWorld-retire");
    }

    @Test(groups={"wso2.bps", "wso2.bps.deployment"}, description="Tests uploading Bpel with retire true", priority=1)
    public void testRetireClient() throws Exception {
        this.deployArtifact();
        Thread.sleep(20000L);
        String processId = this.bpelProcessManagementClient.getProcessId("HelloWorld-retire");
        String status = this.bpelProcessManagementClient.getStatus(processId);
        Assert.assertTrue((boolean)status.equals("RETIRED".toUpperCase()), (String)"Process State is still Active");
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("HelloWorld-retire");
        this.loginLogoutClient.logout();
    }
}

