/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import java.io.File;
import java.net.URL;
import java.util.Calendar;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.integration.common.admin.client.ApplicationAdminClient;
import org.wso2.carbon.integration.common.admin.client.CarbonAppUploaderClient;

public class BPMNCappDeploymentTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPMNCappDeploymentTestCase.class);
    private final int MAX_TIME = 120000;
    private String carFileName = "TestPro_1.0.0";
    private boolean bpmnProcessExists = false;
    private boolean isCarFileUploaded = false;
    private ApplicationAdminClient applicationAdminClient;
    private WorkflowServiceClient workflowServiceClient;

    @BeforeClass(alwaysRun=true)
    public void deployTask() throws Exception {
        super.init();
        CarbonAppUploaderClient carbonAppUploaderClient = new CarbonAppUploaderClient(this.backEndUrl, this.sessionCookie);
        carbonAppUploaderClient.uploadCarbonAppArtifact(this.carFileName + ".car", new DataHandler(new URL("file:" + File.separator + File.separator + FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "bpmn" + File.separator + this.carFileName + ".car")));
        this.isCarFileUploaded = true;
        this.applicationAdminClient = new ApplicationAdminClient(this.backEndUrl, this.sessionCookie);
        boolean result = this.isCarFileDeployed(this.carFileName);
        Assert.assertTrue((boolean)result, (String)"Car file deployment failed");
    }

    @Test(groups={"wso2.bps.task.BPMNArtifacts"}, description="Confirm BPMN artifact deployment of uploaded cApp  test case", priority=1, singleThreaded=true)
    public void confirmBPMNArtifactDeployment() throws Exception {
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        String processId = this.workflowServiceClient.getProcesses()[this.workflowServiceClient.getProcesses().length - 1].getProcessId();
        if (processId != null) {
            this.bpmnProcessExists = true;
            this.workflowServiceClient.startProcess(processId);
            log.info((Object)("BPMN Process:" + processId + " started "));
        }
        Assert.assertTrue((boolean)this.bpmnProcessExists, (String)"Unable to find bpmn processes in deployed car file.");
    }

    private boolean isCarFileDeployed(String carFileName) throws Exception {
        long time;
        log.info((Object)("waiting 120000 millis for car deployment " + carFileName));
        boolean isCarFileDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < 120000L) {
            String[] applicationList = this.applicationAdminClient.listAllApplications();
            if (applicationList != null) {
                for (int i = 0; i < applicationList.length; ++i) {
                    if (!applicationList[i].equals(carFileName)) continue;
                    isCarFileDeployed = true;
                    log.info((Object)("car file deployed in " + time + " mills"));
                    return isCarFileDeployed;
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
        return isCarFileDeployed;
    }

    @AfterClass(alwaysRun=true)
    public void cleanupArtifactsIfExist() throws Exception {
        if (this.isCarFileUploaded) {
            this.applicationAdminClient.deleteApplication(this.carFileName);
            log.info((Object)("Successfully undeployed " + this.carFileName));
        }
    }
}

