/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.tests.bpmn.BPMNTestUtils;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNDeployment;

public class BPMNTaskCreationTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPMNTaskCreationTestCase.class);
    private WorkflowServiceClient workflowServiceClient;
    private int deploymentCount;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.init();
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        BPMNDeployment[] bpmnDeployments = this.workflowServiceClient.getDeployments();
        if (bpmnDeployments != null) {
            this.deploymentCount = this.workflowServiceClient.getDeployments().length;
        }
        this.initialize();
    }

    protected void initialize() throws Exception {
        log.info((Object)"Initializing BPMN task creation Test...");
        this.deployArtifact();
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "HelloApprove", this.deploymentCount);
    }

    public void deployArtifact() throws Exception {
        this.uploadBPMNForTest("HelloApprove");
    }

    @Test(groups={"wso2.bps.task.create"}, description="Hello Approve test case", priority=1, singleThreaded=true)
    public void createTask() {
        try {
            String processId = this.workflowServiceClient.getProcesses()[this.workflowServiceClient.getProcesses().length - 1].getProcessId();
            this.workflowServiceClient.startProcess(processId);
            log.info((Object)("BPMN Process:" + processId + " started "));
            log.info((Object)("BPMN Process has:" + this.workflowServiceClient.getInstanceCount() + " instances "));
            Assert.assertTrue((String)"Create task is successful", (this.workflowServiceClient.getInstanceCount() > 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            String errMsg = "Failed to create bpmn task in HelloApprove process ";
            log.error((Object)errMsg, (Throwable)ex);
            Assert.fail((String)errMsg);
        }
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws Exception {
        this.workflowServiceClient.undeploy("HelloApprove");
        this.loginLogoutClient.logout();
    }
}

