/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;

public class BPMNTestUtils {
    private static final Log log = LogFactory.getLog(BPMNTestUtils.class);

    public static void waitForProcessDeployment(WorkflowServiceClient workflowServiceClient, String bpmnPackageName, int previousDeploymentCount) throws Exception {
        int serviceTimeOut = 0;
        while (workflowServiceClient.getDeployments() == null || workflowServiceClient.getDeployments().length <= previousDeploymentCount) {
            if (serviceTimeOut == 0) {
                log.info((Object)("Waiting for BPMN package" + bpmnPackageName + " to deploy."));
            } else if (serviceTimeOut > 200) {
                String errMsg = bpmnPackageName + " package is not found";
                log.error((Object)errMsg);
                throw new Exception(errMsg);
            }
            try {
                ++serviceTimeOut;
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)("Error while waiting for process deployment " + e));
                continue;
            }
            break;
        }
        return;
    }
}

