/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.ActivitiRestClient;
import org.wso2.bps.integration.common.clients.bpmn.RestClientException;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class ProcessInstanceTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(ProcessInstanceTestCase.class);

    @Test(groups={"wso2.bps.test.processInstance"}, description="Process Instance Test", priority=2, singleThreaded=true)
    public void processInstanceTest() throws Exception {
        this.init();
        ActivitiRestClient tester = new ActivitiRestClient((String)this.bpsServer.getInstance().getPorts().get("http"), (String)this.bpsServer.getInstance().getHosts().get("default"));
        String filePath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "bpmn" + File.separator + "HelloApprove.bar";
        String fileName = "HelloApprove.bar";
        String[] deploymentResponse = new String[]{};
        try {
            deploymentResponse = tester.deployBPMNPackage(filePath, fileName);
            Assert.assertTrue((String)"Deployment was not successful", (boolean)deploymentResponse[0].contains("201"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)("Failed to deploy the bpmn package " + fileName), exception);
            Assert.fail((String)("Failed to deploy the bpmn package " + fileName));
        }
        try {
            String[] deploymentCheckResponse = tester.getDeploymentInfoById(deploymentResponse[1]);
            Assert.assertTrue((String)"Deployment is not present", (boolean)deploymentCheckResponse[2].contains(fileName));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)("Deployed bpmn package " + fileName + " was not found "), exception);
            Assert.fail((String)("Deployed bpmn package " + fileName + " was not found "));
        }
        String[] definitionResponse = new String[]{};
        try {
            definitionResponse = tester.findProcessDefinitionInfoById(deploymentResponse[1]);
            Assert.assertTrue((String)"Search was not success", (boolean)definitionResponse[0].contains("200"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)("Could not find definition id for bpmn package " + fileName), exception);
            Assert.fail((String)("Could not find definition id for bpmn package " + fileName));
        }
        String[] processInstanceResponse = new String[]{};
        try {
            processInstanceResponse = tester.startProcessInstanceByDefintionID(definitionResponse[1]);
            Assert.assertTrue((String)"Process instance cannot be started", (boolean)processInstanceResponse[0].contains("201"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)"Process instance failed to start ", exception);
            Assert.fail((String)"Process instance failed to start ");
        }
        try {
            String searchResponse = tester.searchProcessInstanceByDefintionID(definitionResponse[1]);
            Assert.assertTrue((String)"Process instance does not exist", (boolean)searchResponse.contains("200"));
        }
        catch (IOException exception) {
            log.error((Object)"Process instance cannot be found", (Throwable)exception);
            Assert.fail((String)"Process instance cannot be found");
        }
        try {
            String[] suspendResponse = tester.suspendProcessInstanceById(processInstanceResponse[1]);
            Assert.assertTrue((String)"Process instance cannot be suspended", (boolean)suspendResponse[0].contains("200"));
            Assert.assertTrue((String)"Process instance cannot be suspended", (boolean)suspendResponse[1].contains("true"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)"Process instance cannot be suspended", exception);
            Assert.fail((String)"The Process instance cannot be suspended");
        }
        try {
            String stateVerfication = tester.getSuspendedStateOfProcessInstanceByID(processInstanceResponse[1]);
            Assert.assertTrue((String)"The process instance is not in suspended state", (boolean)stateVerfication.contains("true"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)"The process instance is not in suspended state", exception);
            Assert.fail((String)"The process instance is not in suspended state ");
        }
        String deleteStatus = "";
        try {
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                deleteStatus = tester.deleteProcessInstanceByID(processInstanceResponse[1]);
                if (deleteStatus.contains("204")) break;
            }
            Assert.assertTrue((String)"Process instance cannot be removed", (boolean)deleteStatus.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)"Process instance cannot be removed", (Throwable)exception);
            Assert.fail((String)"Process instance cannot be removed");
        }
        try {
            tester.validateProcessInstanceById(definitionResponse[1]);
            Assert.fail((String)"Process instance stille exists");
        }
        catch (IOException | JSONException | RestClientException exception) {
            Assert.assertTrue((String)"Process instance was removed successfully", (boolean)"Not Available".equals(exception.getMessage()));
        }
        try {
            String undeployStatus = tester.unDeployBPMNPackage(deploymentResponse[1]);
            Assert.assertTrue((String)"Package cannot be undeployed", (boolean)undeployStatus.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)("Failed to undeploy bpmn package " + fileName), (Throwable)exception);
            Assert.fail((String)("Failed to remove bpmn package " + fileName));
        }
        try {
            tester.getDeploymentInfoById(deploymentResponse[1]);
            Assert.fail((String)"Package still exists after undeployment");
        }
        catch (IOException | JSONException | RestClientException exception) {
            Assert.assertTrue((String)("Bpmn package " + fileName + " does not exist"), (boolean)"Not Available".equals(exception.getMessage()));
        }
    }
}

