/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.tests.bpmn.BPMNTaskCreationTestCase;
import org.wso2.bps.integration.tests.bpmn.BPMNTestUtils;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNDeployment;

public class BPMNMultiTenancyTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPMNTaskCreationTestCase.class);
    private WorkflowServiceClient workflowServiceClient;
    private int deploymentCount;
    boolean accessedSameArtifactInstance = false;
    String packageName = "VacationRequest";
    String domainKey1 = "wso2.com";
    String userKey1 = "user1";
    String domainKey2 = "abc.com";
    String userKey2 = "user2";

    @BeforeClass(alwaysRun=true)
    public void createTenant() throws Exception {
        this.initialize(this.domainKey1, this.userKey1);
    }

    public void initialize(String domainKey, String userKey) throws Exception {
        this.init(domainKey, userKey);
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        BPMNDeployment[] bpmnDeployments = this.workflowServiceClient.getDeployments();
        if (bpmnDeployments != null) {
            this.deploymentCount = this.workflowServiceClient.getDeployments().length;
        }
    }

    @Test(groups={"wso2.bps.task.BPMNMultiTenancy"}, description="Confirm BPMN Multi tenancy support test case", priority=1, singleThreaded=true)
    public void confirmMultiTenancyForBPMNArtifact() throws Exception {
        String processId2;
        String session = this.loginLogoutClient.login();
        this.deployArtifact();
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, this.packageName, this.deploymentCount);
        String processId = this.workflowServiceClient.getProcesses()[this.workflowServiceClient.getProcesses().length - 1].getProcessId();
        log.info((Object)("BPMN Process:" + processId + " accessed by tenant t1 " + session));
        this.loginLogoutClient.logout();
        this.initialize(this.domainKey2, this.userKey2);
        this.loginLogoutClient.login();
        int deployedInstance = this.workflowServiceClient.getInstanceCount();
        if (deployedInstance == 0) {
            log.info((Object)("No processes available for tenant:" + this.domainKey2));
        } else if (this.deploymentCount != 0 && (processId2 = this.workflowServiceClient.getProcesses()[this.workflowServiceClient.getProcesses().length - 1].getProcessId()).equals(processId)) {
            this.accessedSameArtifactInstance = true;
        }
        this.loginLogoutClient.logout();
        Assert.assertEquals((boolean)this.accessedSameArtifactInstance, (boolean)false, (String)("Multi-tenancy implementation failed.Artifact deployed by tenant" + this.domainKey1 + "can be accessed by tenant" + this.domainKey2));
    }

    public void deployArtifact() throws Exception {
        this.uploadBPMNForTest(this.packageName);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifact() throws Exception {
        this.initialize(this.domainKey1, this.userKey1);
        this.workflowServiceClient.undeploy(this.packageName);
        log.info((Object)("Successfully undeployed: " + this.packageName));
    }
}

