/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;

public class BPMNTestUtils {
    private static final Log log = LogFactory.getLog(BPMNTestUtils.class);
    private static final String BACKEND_URL_SUFFIX = "services";
    private static final String BPMN_REST_URL_SUFFIX = "bpmn";

    public static void waitForProcessDeployment(WorkflowServiceClient workflowServiceClient, String bpmnPackageName, int previousDeploymentCount) throws Exception {
        int serviceTimeOut = 0;
        while (workflowServiceClient.getDeployments() == null || workflowServiceClient.getDeployments().length <= previousDeploymentCount) {
            if (serviceTimeOut == 0) {
                log.info((Object)("Waiting for BPMN package" + bpmnPackageName + " to deploy."));
            } else if (serviceTimeOut > 200) {
                String errMsg = bpmnPackageName + " package is not found";
                log.error((Object)errMsg);
                throw new Exception(errMsg);
            }
            try {
                ++serviceTimeOut;
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)("Error while waiting for process deployment " + e));
                continue;
            }
            break;
        }
        return;
    }

    public static String getRestEndPoint(String backEndUrl) {
        return backEndUrl.replaceFirst(BACKEND_URL_SUFFIX, BPMN_REST_URL_SUFFIX);
    }

    public static String getRequest(String url) throws IOException {
        String restUrl = BPMNTestUtils.getRestEndPoint(url);
        log.info((Object)("Sending HTTP GET request: " + restUrl));
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(restUrl);
        request.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials("admin", "admin"), (String)"UTF-8", (boolean)false));
        client.getConnectionManager().closeExpiredConnections();
        HttpResponse response = client.execute((HttpUriRequest)request);
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    public static HttpResponse getRequestResponse(String url) throws IOException {
        String restUrl = BPMNTestUtils.getRestEndPoint(url);
        log.info((Object)("Sending HTTP GET request: " + restUrl));
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(restUrl);
        request.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials("admin", "admin"), (String)"UTF-8", (boolean)false));
        client.getConnectionManager().closeExpiredConnections();
        HttpResponse response = client.execute((HttpUriRequest)request);
        return response;
    }

    public static HttpResponse postRequest(String url, JSONObject payload) throws IOException {
        String restUrl = BPMNTestUtils.getRestEndPoint(url);
        log.info((Object)("Sending HTTP POST request: " + restUrl));
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(restUrl);
        post.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials("admin", "admin"), (String)"UTF-8", (boolean)false));
        post.setEntity((HttpEntity)new StringEntity(payload.toString(), ContentType.APPLICATION_JSON));
        client.getConnectionManager().closeExpiredConnections();
        HttpResponse response = client.execute((HttpUriRequest)post);
        return response;
    }

    public static HttpResponse postRequest(String url, JSONArray payload) throws IOException, JSONException {
        String restUrl = BPMNTestUtils.getRestEndPoint(url);
        log.info((Object)("Sending HTTP POST request: " + restUrl));
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(restUrl);
        post.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials("admin", "admin"), (String)"UTF-8", (boolean)false));
        post.setEntity((HttpEntity)new StringEntity(payload.toString(), ContentType.APPLICATION_JSON));
        client.getConnectionManager().closeExpiredConnections();
        HttpResponse response = client.execute((HttpUriRequest)post);
        return response;
    }

    public static HttpResponse deleteRequest(String url) throws IOException {
        String restUrl = BPMNTestUtils.getRestEndPoint(url);
        log.info((Object)("Sending HTTP DELETE request: " + restUrl));
        DefaultHttpClient client = new DefaultHttpClient();
        HttpDelete delete = new HttpDelete(restUrl);
        delete.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials("admin", "admin"), (String)"UTF-8", (boolean)false));
        client.getConnectionManager().closeExpiredConnections();
        HttpResponse response = client.execute((HttpUriRequest)delete);
        return response;
    }

    public static HttpResponse putRequest(String url, JSONObject payload) throws IOException {
        String restUrl = BPMNTestUtils.getRestEndPoint(url);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPut put = new HttpPut(restUrl);
        put.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials("admin", "admin"), (String)"UTF-8", (boolean)false));
        put.setEntity((HttpEntity)new StringEntity(payload.toString(), ContentType.APPLICATION_JSON));
        client.getConnectionManager().closeExpiredConnections();
        HttpResponse response = client.execute((HttpUriRequest)put);
        return response;
    }
}

