/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn.rest;

import java.util.List;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.tests.bpmn.BPMNTestUtils;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNInstance;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNProcess;

public class BPMNRestExecutionTest
extends BPSMasterTest {
    WorkflowServiceClient workflowServiceClient;
    public static final String executionsUrl = "runtime/executions";

    @BeforeTest
    public void init() throws Exception {
        super.init();
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        this.loginLogoutClient.login();
        this.uploadBPMNForTest("ExecutionResourceTest");
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "ExecutionResourceTest", 0);
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="get executions", priority=1, singleThreaded=true)
    public void testGetExecutions() throws Exception {
        HttpResponse response;
        JSONObject jsonObject;
        BPMNProcess[] bpmnProcesses = this.workflowServiceClient.getProcesses();
        String processId = null;
        for (BPMNProcess process : bpmnProcesses) {
            if (!process.getKey().equals("processOneExec")) continue;
            processId = process.getProcessId();
            this.workflowServiceClient.getInstanceServiceStub().startProcess(processId);
            break;
        }
        Assert.assertTrue((String)"runtime/executions test", ((jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)(response = BPMNTestUtils.getRequestResponse(this.backEndUrl + executionsUrl)).getEntity()))).getInt("total") > 1 ? 1 : 0) != 0);
        List bpmnInstances = this.workflowServiceClient.getProcessInstancesByProcessId(processId);
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + executionsUrl + "?processDefinitionId=" + processId);
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        JSONArray dataArray = (JSONArray)jsonObject.get("data");
        for (int i = 0; i < jsonObject.getInt("size"); ++i) {
            String instanceId = ((JSONObject)dataArray.get(i)).getString("processInstanceId");
            Assert.assertTrue((String)"runtime/executions?processDefinitionId test", (instanceId.equals(((BPMNInstance)bpmnInstances.get(0)).getInstanceId()) || instanceId.equals(((BPMNInstance)bpmnInstances.get(1)).getInstanceId()) ? 1 : 0) != 0);
        }
        String executionId = ((JSONObject)dataArray.get(0)).getString("id");
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + executionsUrl + "/" + executionId);
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"runtime/executions/{executionId} test", (String)executionId, (String)jsonObject.getString("id"));
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + executionsUrl + "/" + executionId + "/activities");
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        Assert.assertTrue((String)"runtime/executions/{executionId}/activities test", (boolean)result.contains("processTask"));
        for (BPMNProcess process : bpmnProcesses) {
            if (!process.getKey().equals("processOneSignal")) continue;
            processId = process.getProcessId();
            this.workflowServiceClient.getInstanceServiceStub().startProcess(processId);
            break;
        }
        bpmnInstances = this.workflowServiceClient.getProcessInstancesByProcessId(processId);
        String action = "{\"action\":\"signal\"}";
        response = BPMNTestUtils.putRequest(this.backEndUrl + executionsUrl + "/" + ((BPMNInstance)bpmnInstances.get(0)).getInstanceId(), new JSONObject(action));
        Assert.assertEquals((String)"PUT runtime/executions/{executionId} test", (int)200, (int)response.getStatusLine().getStatusCode());
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + executionsUrl + "/" + ((BPMNInstance)bpmnInstances.get(0)).getInstanceId());
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"PUT runtime/executions/{executionId} test", (String)"anotherWaitState", (String)jsonObject.getString("activityId"));
    }
}

