/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn.rest;

import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.tests.bpmn.BPMNTestUtils;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNInstance;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNProcess;
import org.wso2.carbon.bpmn.stub.BPMNInstanceServiceStub;

public class BPMNRestProcessInstancesTest
extends BPSMasterTest {
    WorkflowServiceClient workflowServiceClient;
    public static final String instanceUrl = "runtime/process-instances";

    @BeforeTest
    public void init() throws Exception {
        super.init();
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        this.loginLogoutClient.login();
        this.uploadBPMNForTest("ProcessInstanceResourceTest");
        int deploymentCount = 0;
        if (this.workflowServiceClient.getDeployments() != null) {
            deploymentCount = this.workflowServiceClient.getDeployments().length;
        }
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "ProcessInstanceResourceTest", deploymentCount);
    }

    @AfterTest
    public void afterTest() throws Exception {
        this.workflowServiceClient.undeploy("ProcessInstanceResourceTest");
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="get process instances", priority=1, singleThreaded=true)
    public void testGetProcessInstances() throws Exception {
        BPMNProcess[] bpmnProcesses = this.workflowServiceClient.getProcesses();
        BPMNInstanceServiceStub bpmnInstanceServiceStub = this.workflowServiceClient.getInstanceServiceStub();
        for (BPMNProcess process : bpmnProcesses) {
            bpmnInstanceServiceStub.startProcess(process.getProcessId());
        }
        String result = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl);
        JSONObject jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"runtime/process-instances/ test", (int)this.workflowServiceClient.getProcessInstances().length, (int)jsonObject.getInt("total"));
        Assert.assertTrue((String)"runtime/process-instances/ test", (boolean)jsonObject.getString("data").contains(bpmnProcesses[0].getProcessId()));
        Assert.assertTrue((String)"runtime/process-instances/ test", (boolean)jsonObject.getString("data").contains(bpmnProcesses[1].getProcessId()));
        result = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl + "?id=" + this.workflowServiceClient.getProcessInstances()[0].getInstanceId());
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"runtime/process-instances?id= test", (String)this.workflowServiceClient.getProcessInstances()[0].getInstanceId(), (String)((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getString("id"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl + "?processDefinitionId=" + bpmnProcesses[0].getProcessId());
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"runtime/process-instances?processDefinitionId= test", (String)bpmnProcesses[0].getProcessId(), (String)((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getString("processDefinitionId"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl + "?processDefinitionId=" + "nonExistingId");
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"runtime/process-instances?processDefinitionId= test", (int)0, (int)jsonObject.getInt("total"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl + "?suspended=false");
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"runtime/process-instances?suspended= test", (int)this.workflowServiceClient.getProcessInstances().length, (int)jsonObject.getInt("total"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl + "/" + this.workflowServiceClient.getProcessInstances()[0].getInstanceId());
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"runtime/process-instances/{instanceId} test", (String)this.workflowServiceClient.getProcessInstances()[0].getInstanceId(), (String)jsonObject.getString("id"));
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="start process instances", priority=1, singleThreaded=true)
    public void testStartProcessInstances() throws Exception {
        BPMNProcess[] bpmnProcesses = this.workflowServiceClient.getProcesses();
        String payloadString = "{\n\"processDefinitionId\":\"" + bpmnProcesses[0].getProcessId() + "\"," + "\"businessKey\":\"myBusinessKey\"" + "}";
        JSONObject jsonPayload = new JSONObject(payloadString);
        HttpResponse response = BPMNTestUtils.postRequest(this.backEndUrl + instanceUrl, jsonPayload);
        String resultSet = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResult = new JSONObject(resultSet);
        Assert.assertEquals((String)"runtime/process-instances POST test", (Object)"myBusinessKey", (Object)jsonResult.get("businessKey"));
        String result = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl);
        Assert.assertTrue((String)"runtime/process-instances POST test", (boolean)result.contains("myBusinessKey"));
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="get instance resources", priority=1, singleThreaded=true)
    public void testGetInstanceResources() throws Exception {
        String processId = null;
        for (BPMNProcess process : this.workflowServiceClient.getProcesses()) {
            if (!process.getKey().equals("simpleProcess")) continue;
            processId = process.getProcessId();
            break;
        }
        this.workflowServiceClient.getInstanceServiceStub().startProcess(processId);
        BPMNInstance[] bpmnInstances = this.workflowServiceClient.getProcessInstances();
        HttpResponse result = BPMNTestUtils.getRequestResponse(this.backEndUrl + instanceUrl + "/" + bpmnInstances[0].getInstanceId() + "/diagram");
        Assert.assertEquals((String)"runtime/process-instances/{instanceId}/diagram test", (String)"image/png", (String)result.getEntity().getContentType().getValue());
        String resultStr = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl + "/" + bpmnInstances[0].getInstanceId() + "/identitylinks");
        resultStr = "{ \"data\":" + resultStr + "}";
        JSONObject jsonObject = new JSONObject(resultStr);
        Assert.assertEquals((String)"runtime/process-instances/{instanceId}/identitykinks test", (int)0, (int)((JSONArray)jsonObject.get("data")).length());
        String userRequest = "{\"user\":\"kermit\",\"type\":\"participant\"}";
        result = BPMNTestUtils.postRequest(this.backEndUrl + instanceUrl + "/" + bpmnInstances[0].getInstanceId() + "/identitylinks", new JSONObject(userRequest));
        Assert.assertEquals((String)"POST runtime/process-instances/{instanceId}/identitykinks test", (int)201, (int)result.getStatusLine().getStatusCode());
        resultStr = BPMNTestUtils.getRequest(this.backEndUrl + instanceUrl + "/" + bpmnInstances[0].getInstanceId() + "/identitylinks");
        resultStr = "{ \"data\":" + resultStr + "}";
        jsonObject = new JSONObject(resultStr);
        Assert.assertEquals((String)"runtime/process-instances/{instanceId}/identitylinks test", (String)"kermit", (String)((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getString("user"));
        result = BPMNTestUtils.getRequestResponse(this.backEndUrl + instanceUrl + "/" + bpmnInstances[0].getInstanceId() + "/identitylinks/users/kermit/participant");
        Assert.assertEquals((String)"runtime/process-instances//{processInstanceId}/identitylinks/users/{identityId}/{type} test", (int)200, (int)result.getStatusLine().getStatusCode());
        result = BPMNTestUtils.deleteRequest(this.backEndUrl + instanceUrl + "/" + bpmnInstances[0].getInstanceId() + "/identitylinks/users/kermit/participant");
        Assert.assertEquals((String)"runtime/process-instances/{instanceId}/identitylinks test", (int)204, (int)result.getStatusLine().getStatusCode());
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="update instance resources", priority=1, singleThreaded=true)
    public void testUpdateInstanceResources() throws Exception {
        String activateString = "{\"action\":\"activate\"}";
        String suspendString = "{\"action\":\"suspend\"}";
        HttpResponse result = BPMNTestUtils.putRequest(this.backEndUrl + instanceUrl + "/" + "0", new JSONObject(activateString));
        Assert.assertEquals((String)"runtime/process-instances/{instanceId} PUT test", (int)404, (int)result.getStatusLine().getStatusCode());
        BPMNProcess[] processes = this.workflowServiceClient.getProcesses();
        this.workflowServiceClient.getInstanceServiceStub().startProcess(processes[0].getProcessId());
        String instanceId = this.workflowServiceClient.getProcessInstances()[0].getInstanceId();
        result = BPMNTestUtils.putRequest(this.backEndUrl + instanceUrl + "/" + instanceId, new JSONObject(suspendString));
        Assert.assertEquals((String)"runtime/process-instances/{instanceId} PUT test", (int)200, (int)result.getStatusLine().getStatusCode());
        result = BPMNTestUtils.putRequest(this.backEndUrl + instanceUrl + "/" + instanceId, new JSONObject(activateString));
        Assert.assertEquals((String)"runtime/process-instances/{instanceId} PUT test", (int)200, (int)result.getStatusLine().getStatusCode());
        result = BPMNTestUtils.putRequest(this.backEndUrl + instanceUrl + "/" + instanceId, new JSONObject(activateString));
        Assert.assertEquals((String)"runtime/process-instances/{instanceId} PUT test", (int)500, (int)result.getStatusLine().getStatusCode());
        result = BPMNTestUtils.deleteRequest(this.backEndUrl + instanceUrl + "/" + instanceId);
        Assert.assertEquals((String)"runtime/process-instances/{instanceId} DELETE test", (int)204, (int)result.getStatusLine().getStatusCode());
    }
}

