/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.tests.bpmn.BPMNTestUtils;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class BPMNUserSubstitutionTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPMNUserSubstitutionTestCase.class);
    private ServerConfigurationManager serverConfigurationManager;
    private UserManagementClient userManagementClient;
    private WorkflowServiceClient workflowServiceClient;
    public static final String USER_PW = "password";
    private static final String USER1 = "testUser1";
    private static final String USER2 = "testUser2";
    private static final String USER3 = "testUser3";
    private static final String SUBSTTUTER_ROLE = "subRole";
    private static final String NON_SUB_ROLE = "nonSubRole";
    public static final String SUBSTITUTION_PERMISSION_PATH = "/permission/admin/manage/bpmn/addSubstituteInfo";
    public static final String LOGIN_PERMISSION_PATH = "/permission/admin/login";
    public static final String PROCESS_NAME = "UserTaskProcess";
    public static final String SUBSTITUTE_URL = "runtime/substitutes";

    @BeforeTest(alwaysRun=true)
    public void init() throws Exception {
        super.init();
        this.serverConfigurationManager = new ServerConfigurationManager(this.bpsServer);
        this.updateConfigFiles();
        super.init();
        this.loginLogoutClient.login();
        this.userManagementClient = new UserManagementClient(this.backEndUrl, this.sessionCookie);
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        this.serverConfigurationManager = new ServerConfigurationManager(this.bpsServer);
        log.info((Object)"Server setup completed with substitution configs enabled.");
        this.addRoles();
    }

    private void updateConfigFiles() throws Exception {
        String artifactLocation = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "configs" + File.separator;
        File activitiConfigNew = new File(artifactLocation + "activiti.xml");
        File activitiConfigOriginal = new File(FrameworkPathUtil.getCarbonServerConfLocation() + File.separator + "activiti.xml");
        this.serverConfigurationManager.applyConfiguration(activitiConfigNew, activitiConfigOriginal, true, true);
    }

    @Test(groups={"wso2.bps.bpmn.substitution"}, description="new substitute addition", priority=1, singleThreaded=true)
    public void testAddSubstitute() throws Exception {
        this.addUser(USER1, new String[]{SUBSTTUTER_ROLE});
        this.addUser(USER2, new String[]{NON_SUB_ROLE});
        this.loginLogoutClient.login();
        this.uploadBPMNForTest(PROCESS_NAME);
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, PROCESS_NAME, 0);
        for (int i = 0; i < 10; ++i) {
            this.startProcessInstance(USER2, "admin", "-1234");
        }
        JSONObject existingTasks = this.findTasksWithGivenAssignee(USER2);
        int response = this.addSubstituteUser(USER1, USER2, new DateTime(), new DateTime(System.currentTimeMillis() + 3600000L), null);
        Assert.assertEquals((int)response, (int)201, (String)"New substitute creation test");
        JSONObject obj = this.findTasksWithGivenAssignee(USER2);
        for (int i = 0; i < 5 && obj.getInt("total") > 0; ++i) {
            obj = this.findTasksWithGivenAssignee(USER2);
        }
        Assert.assertEquals((int)obj.getInt("total"), (int)0, (String)"Task reassignment after substitute request");
        if (existingTasks.getInt("total") > 0) {
            JSONArray tasks = (JSONArray)existingTasks.get("data");
            for (int i = 0; i < existingTasks.getInt("total"); ++i) {
                String id = ((JSONObject)tasks.get(i)).getString("id");
                String res = BPMNTestUtils.getRequest(this.backEndUrl + "runtime/tasks/" + id);
                String newAssignee = new JSONObject(res).getString("assignee");
                Assert.assertEquals((String)newAssignee, (String)USER1, (String)"Task reassignment to the substitute");
            }
        }
        int user1TaskCount = this.findTasksWithGivenAssignee(USER1).getInt("total");
        this.startProcessInstance(USER2, "admin", "-1234");
        obj = this.findTasksWithGivenAssignee(USER2);
        Assert.assertEquals((int)obj.getInt("total"), (int)0, (String)"Future task substitution");
    }

    @Test(groups={"wso2.bps.bpmn.substitution"}, description="update substitute record", priority=2, singleThreaded=true, dependsOnMethods={"testAddSubstitute"})
    public void testUpdateSubstituteUser() throws IOException, JSONException {
        this.addUser(USER3, new String[]{"admin"});
        int result = this.updateSubstitute(USER3, USER2, null, null);
        Assert.assertEquals((int)result, (int)200, (String)"Update active substitution record");
        String getSubResult = BPMNTestUtils.getRequest(this.backEndUrl + SUBSTITUTE_URL + "/" + USER2);
        JSONObject getSubJson = new JSONObject(getSubResult);
        Assert.assertEquals((String)getSubJson.getString("substitute"), (String)USER3, (String)"Update active substitution record");
        int user1TaskCount = this.findTasksWithGivenAssignee(USER1).getInt("total");
        int user3taskCount = this.findTasksWithGivenAssignee(USER3).getInt("total");
        this.startProcessInstance(USER2, "admin", "-1234");
        this.startProcessInstance(USER2, "admin", "-1234");
        Assert.assertEquals((int)this.findTasksWithGivenAssignee(USER1).getInt("total"), (int)user1TaskCount, (String)"Future task Substitution after a update");
    }

    private void waitForTaskAssignments(int expectedCount, String user) throws IOException, JSONException {
        for (int i = 0; i < 5 && expectedCount != this.findTasksWithGivenAssignee(user).getInt("total"); ++i) {
        }
    }

    private JSONObject findTasksWithGivenAssignee(String assignee) throws JSONException, IOException {
        String payload = "{\"assignee\":\"" + assignee + "\"" + "}";
        HttpResponse taskQueryResponse = BPMNTestUtils.postRequest(this.backEndUrl + "query/tasks", new JSONObject(payload));
        return new JSONObject(EntityUtils.toString((HttpEntity)taskQueryResponse.getEntity()));
    }

    private void addUser(String user, String[] role) {
        try {
            this.userManagementClient.addUser(user, user, role, "test");
        }
        catch (RemoteException | UserAdminUserAdminException e) {
            log.error((Object)"Error adding new user for testing", e);
        }
    }

    private void addRoles() {
        try {
            this.userManagementClient.addRole(SUBSTTUTER_ROLE, null, new String[]{SUBSTITUTION_PERMISSION_PATH, LOGIN_PERMISSION_PATH});
            this.userManagementClient.addRole(NON_SUB_ROLE, null, new String[]{LOGIN_PERMISSION_PATH});
        }
        catch (RemoteException | UserAdminUserAdminException e) {
            log.error((Object)"Error adding a new role.", e);
        }
    }

    private void startProcessInstance(String user, String role, String tenantId) throws JSONException, IOException {
        String arrayString = "[{\"name\":\"user\", \"value\":\"" + user + "\"}, {\"name\":\"role\",\"value\":\"" + role + "\"}]";
        JSONArray varArray = new JSONArray(arrayString);
        JSONObject payload = new JSONObject();
        payload.put("variables", (Object)varArray);
        payload.put("tenantId", (Object)tenantId);
        payload.put("processDefinitionKey", (Object)PROCESS_NAME);
        BPMNTestUtils.postRequest(this.backEndUrl + "runtime/process-instances", payload);
    }

    private int addSubstituteUser(String substitute, String assignee, DateTime start, DateTime end, List<String> taskList) throws JSONException, IOException {
        JSONObject payload = new JSONObject();
        if (assignee != null) {
            payload.put("assignee", (Object)assignee);
        }
        if (substitute != null) {
            payload.put("substitute", (Object)substitute);
        }
        DateTimeFormatter isoFormat = ISODateTimeFormat.dateTime();
        if (start != null) {
            payload.put("startTime", (Object)isoFormat.print((ReadableInstant)start));
        }
        if (end != null) {
            payload.put("endTime", (Object)isoFormat.print((ReadableInstant)end));
        }
        if (taskList != null && !taskList.isEmpty()) {
            JSONArray taskArray = new JSONArray();
            for (String id : taskList) {
                taskArray.put((Object)id);
            }
            payload.put("taskList", (Object)taskArray);
        }
        HttpResponse response = BPMNTestUtils.postRequest(this.backEndUrl + SUBSTITUTE_URL, payload);
        return response.getStatusLine().getStatusCode();
    }

    private int updateSubstitute(String substitute, String assignee, DateTime start, DateTime end) throws JSONException, IOException {
        JSONObject payload = new JSONObject();
        if (substitute != null) {
            payload.put("substitute", (Object)substitute);
        }
        DateTimeFormatter isoFormat = ISODateTimeFormat.dateTime();
        if (start != null) {
            payload.put("startTime", (Object)isoFormat.print((ReadableInstant)start));
        }
        if (end != null) {
            payload.put("endTime", (Object)isoFormat.print((ReadableInstant)end));
        }
        HttpResponse response = BPMNTestUtils.putRequest(this.backEndUrl + SUBSTITUTE_URL + "/" + assignee, payload);
        return response.getStatusLine().getStatusCode();
    }

    @AfterClass(alwaysRun=true)
    public void cleanServer() throws Exception {
        this.workflowServiceClient.undeploy(PROCESS_NAME);
    }
}

