/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.ActivitiRestClient;
import org.wso2.bps.integration.common.clients.bpmn.RestClientException;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class JavaServiceTaskDeploymentUndeploymentTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(JavaServiceTaskDeploymentUndeploymentTestCase.class);

    @BeforeClass
    public void envSetup() throws Exception {
        this.init();
        String artifactLocation = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "bpmn" + File.separator + "testArtifactid-1.0.jar";
        ServerConfigurationManager Loader = new ServerConfigurationManager(this.bpsServer);
        File javaArtifact = new File(artifactLocation);
        Loader.copyToComponentLib(javaArtifact);
        Loader.restartForcefully();
        this.init();
    }

    @Test(groups={"wso2.bps.test.deploy.JavaServiceTask"}, description="Deploy/UnDeploy Package Test", priority=1, singleThreaded=true)
    public void deployUnDeployJavaServiceTaskBPMNPackage() throws Exception {
        this.init();
        ActivitiRestClient tester = new ActivitiRestClient((String)this.bpsServer.getInstance().getPorts().get("http"), (String)this.bpsServer.getInstance().getHosts().get("default"));
        String filePath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "bpmn" + File.separator + "sampleJavaServiceTask" + ".bar";
        String fileName = "sampleJavaServiceTask.bar";
        String[] deploymentResponse = new String[]{};
        String[] definitionResponse = new String[]{};
        try {
            deploymentResponse = tester.deployBPMNPackage(filePath, fileName);
            Assert.assertTrue((String)"Deployment was not successful", (boolean)deploymentResponse[0].contains("201"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)("Failed to deploy the bpmn package " + fileName), exception);
            Assert.fail((String)("Failed to deploy the bpmn package " + fileName));
        }
        try {
            String[] deploymentCheckResponse = tester.getDeploymentInfoById(deploymentResponse[1]);
            Assert.assertTrue((String)"Deployment doesn not exist", (boolean)deploymentCheckResponse[2].contains(fileName));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)("Deployed BPMN Package " + fileName + " was not found "), exception);
            Assert.fail((String)("Deployed BPMN Package " + fileName + " was not found "));
        }
        try {
            definitionResponse = tester.findProcessDefinitionInfoById(deploymentResponse[1]);
            Assert.assertTrue((String)"Search Success", (boolean)definitionResponse[0].contains("200"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)("Could not find definition id for the bpmn package " + fileName), exception);
            Assert.fail((String)("Could not find definition id for the bpmn package " + fileName));
        }
        String[] processInstanceResponse = new String[]{};
        try {
            processInstanceResponse = tester.startProcessInstanceByDefintionID(definitionResponse[1]);
            Assert.assertTrue((String)"Process instance cannot be started", (boolean)processInstanceResponse[0].contains("201"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)"Process instance failed to start ", exception);
            Assert.fail((String)"Process instance failed to start ");
        }
        try {
            String searchResponse = tester.searchProcessInstanceByDefintionID(definitionResponse[1]);
            Assert.assertTrue((String)"Process instance does not exist", (boolean)searchResponse.contains("200"));
        }
        catch (IOException exception) {
            log.error((Object)"Process instance cannot be found", (Throwable)exception);
            Assert.fail((String)"Process instance cannot be found");
        }
        try {
            String[] invocationResponse = tester.getValueOfVariableOfProcessInstanceById(processInstanceResponse[1], "executionState");
            Assert.assertTrue((String)"Variable is not present", (boolean)invocationResponse[0].contains("200"));
            Assert.assertTrue((String)"Variable is not present", (boolean)invocationResponse[1].contains("executionState"));
            Assert.assertTrue((String)"Variable is not true, java service task has not been executed", (boolean)invocationResponse[2].contains("true"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)"Execution variable response cannot be found ", exception);
            Assert.fail((String)"The execution variable response cannot be found ");
        }
        try {
            String[] suspendResponse = tester.suspendProcessInstanceById(processInstanceResponse[1]);
            Assert.assertTrue((String)"Process instance has not been suspended", (boolean)suspendResponse[0].contains("200"));
            Assert.assertTrue((String)"Process instance has not been suspended", (boolean)suspendResponse[1].contains("true"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)"Process instance cannot be suspended", exception);
            Assert.fail((String)"The process instance cannot be suspended");
        }
        try {
            String stateVerfication = tester.getSuspendedStateOfProcessInstanceByID(processInstanceResponse[1]);
            Assert.assertTrue((String)"The process instance is not in suspended state", (boolean)stateVerfication.contains("true"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)"The process instance is not in suspended state ", exception);
            Assert.fail((String)"The process instance is not in suspended state ");
        }
        try {
            String deleteStatus = tester.deleteProcessInstanceByID(processInstanceResponse[1]);
            Assert.assertTrue((String)"Process instance cannot be removed", (boolean)deleteStatus.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)"Process instance cannot be removed", (Throwable)exception);
            Assert.fail((String)"Process instance cannot be removed");
        }
        try {
            tester.validateProcessInstanceById(definitionResponse[1]);
            Assert.fail((String)"Process instance still exists");
        }
        catch (IOException | JSONException | RestClientException exception) {
            Assert.assertTrue((String)"Process instance was removed successfully", (boolean)"Not Available".equals(exception.getMessage()));
        }
        try {
            String undeployStatus = tester.unDeployBPMNPackage(deploymentResponse[1]);
            Assert.assertTrue((String)"Package cannot be undeployed", (boolean)undeployStatus.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)("Failed to remove bpmn package " + fileName), (Throwable)exception);
            Assert.fail((String)("Failed to remove bpnm package " + fileName));
        }
        try {
            tester.getDeploymentInfoById(deploymentResponse[1]);
            Assert.fail((String)"Package still exists After undeployment");
        }
        catch (IOException | JSONException | RestClientException exception) {
            Assert.assertTrue((String)("BPMN package " + fileName + " Does Not Exist"), (boolean)"Not Available".equals(exception.getMessage()));
        }
    }
}

