/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.ActivitiRestClient;
import org.wso2.bps.integration.common.clients.bpmn.RestClientException;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class UserTaskTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(UserTaskTestCase.class);

    @Test(groups={"wso2.bps.test.usertasks"}, description="User Task Test", priority=1, singleThreaded=true)
    public void userTaskTest() throws Exception {
        this.init();
        ActivitiRestClient tester = new ActivitiRestClient((String)this.bpsServer.getInstance().getPorts().get("http"), (String)this.bpsServer.getInstance().getHosts().get("default"));
        String filePath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "bpmn" + File.separator + "AssigneeIsEmpty.bar";
        String fileName = "AssigneeIsEmpty.bar";
        String[] deploymentResponse = new String[]{};
        try {
            deploymentResponse = tester.deployBPMNPackage(filePath, fileName);
            Assert.assertTrue((String)"Deployment not successful", (boolean)deploymentResponse[0].contains("201"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)("Failed to deploy bpmn package" + fileName), exception);
            Assert.fail((String)("Failed to deploy bpmn package " + fileName));
        }
        try {
            String[] deploymentCheckResponse = tester.getDeploymentInfoById(deploymentResponse[1]);
            Assert.assertTrue((String)"Deployment is not present", (boolean)deploymentCheckResponse[2].contains(fileName));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)("Deployed bpmn package " + fileName + " was not found "), exception);
            Assert.fail((String)("Deployed bpmn package " + fileName + " was not found "));
        }
        String[] definitionResponse = new String[]{};
        try {
            definitionResponse = tester.findProcessDefinitionInfoById(deploymentResponse[1]);
            Assert.assertTrue((String)"Search was not successful", (boolean)definitionResponse[0].contains("200"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)("Could not find definition id for bpmn package " + fileName), exception);
            Assert.fail((String)("Could not find definition if for bpmn package" + fileName));
        }
        String[] processInstanceResponse = new String[]{};
        try {
            processInstanceResponse = tester.startProcessInstanceByDefintionID(definitionResponse[1]);
            Assert.assertTrue((String)"Process instance cannot be started", (boolean)processInstanceResponse[0].contains("201"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)"Process instance failed to start ", exception);
            Assert.fail((String)"Process instance failed to start ");
        }
        try {
            String searchResponse = tester.searchProcessInstanceByDefintionID(definitionResponse[1]);
            Assert.assertTrue((String)"Process instance not present", (boolean)searchResponse.contains("200"));
        }
        catch (IOException exception) {
            log.error((Object)"Process instance cannot be found", (Throwable)exception);
            Assert.fail((String)"Process instance cannot be found");
        }
        String[] taskResponse = new String[]{};
        try {
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                taskResponse = tester.findTaskIdByProcessInstanceID(processInstanceResponse[1]);
                if (taskResponse != null) break;
            }
            Assert.assertTrue((String)"Task ID cannot be acquired", (boolean)taskResponse[0].contains("200"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)"Could not identify the task ID", exception);
            Assert.fail((String)"Could not identify the task ID");
        }
        try {
            String claimResponse = tester.claimTaskByTaskId(taskResponse[1]);
            Assert.assertTrue((String)"User has cannot claim task", (boolean)claimResponse.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)"The Task was not claimable", (Throwable)exception);
            Assert.fail((String)"The Task was not claimable");
        }
        String currentAssignee = null;
        try {
            currentAssignee = tester.getAssigneeByTaskId(taskResponse[1]);
            Assert.assertTrue((String)"User has cannot be assigned", (boolean)currentAssignee.contains("paul"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)"The task not assigned to user", exception);
            Assert.fail((String)"The task not assigned to user");
        }
        try {
            String delegateStatus = tester.delegateTaskByTaskId(taskResponse[1]);
            Assert.assertTrue((String)"Task has not been delegated", (boolean)delegateStatus.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)"Failed to Delegate Task", (Throwable)exception);
            Assert.fail((String)"Failed to Delegate Task");
        }
        try {
            currentAssignee = tester.getAssigneeByTaskId(taskResponse[1]);
            Assert.assertTrue((String)"Delegated name does not match assignee", (boolean)currentAssignee.equals("will"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)"Delegated user does not match assignee", exception);
            Assert.fail((String)"Delegated user does not match assignee");
        }
        String[] commentResponse = new String[]{};
        try {
            commentResponse = tester.addNewCommentOnTaskByTaskId(taskResponse[1], "Testing 123");
            Assert.assertTrue((String)"Comment can not be added", (boolean)commentResponse[0].contains("201"));
            Assert.assertTrue((String)"Comment is not visible", (boolean)commentResponse[1].contains("Testing 123"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)"Comment was not added", exception);
            Assert.fail((String)"Comment was not added");
        }
        try {
            String validateComment = tester.getCommentByTaskIdAndCommentId(taskResponse[1], commentResponse[2]);
            Assert.assertTrue((String)"comment does not exist", (boolean)validateComment.contains("Testing 123"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)"Comment does not exist", exception);
            Assert.fail((String)"Comment does not exist");
        }
        try {
            String status = tester.resolveTaskByTaskId(taskResponse[1]);
            String stateValue = tester.getDelegationsStateByTaskId(taskResponse[1]);
            Assert.assertTrue((String)"Failed to set task to resolved state", (boolean)stateValue.equals("resolved"));
        }
        catch (IOException | JSONException exception) {
            log.error((Object)"Failed to set task state to resolved", exception);
            Assert.fail((String)"Failed to set task state to resolved");
        }
        try {
            String deleteStatus = tester.deleteProcessInstanceByID(processInstanceResponse[1]);
            Assert.assertTrue((String)"Process instance cannot be removed", (boolean)deleteStatus.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)"Process instance cannot be removed", (Throwable)exception);
            Assert.fail((String)"Process instance cannot be removed");
        }
        try {
            tester.validateProcessInstanceById(definitionResponse[1]);
            Assert.fail((String)"Process Instance still exists");
        }
        catch (IOException | JSONException | RestClientException exception) {
            Assert.assertTrue((String)"Process instance was removed successfully", (boolean)"Not Available".equals(exception.getMessage()));
        }
        try {
            String undeployStatus = tester.unDeployBPMNPackage(deploymentResponse[1]);
            Assert.assertTrue((String)"Package was not undeployed", (boolean)undeployStatus.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)("Failed to remove BPMN Package " + fileName), (Throwable)exception);
            Assert.fail((String)("Failed to remove BPMN Package " + fileName));
        }
        try {
            tester.getDeploymentInfoById(deploymentResponse[1]);
            Assert.fail((String)"Bpmn package still exists After undeployment");
        }
        catch (IOException | JSONException | RestClientException exception) {
            Assert.assertTrue((String)("BPMN Package " + fileName + " Does Not Exist"), (boolean)"Not Available".equals(exception.getMessage()));
        }
    }
}

