/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.ActivitiRestClient;
import org.wso2.bps.integration.common.clients.bpmn.RestClientException;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class ValidBPMNPackageDeploymentTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(ValidBPMNPackageDeploymentTestCase.class);

    @Test(groups={"wso2.bps.test.deploy"}, description="Deploy/UnDeploy Package Test", priority=1, singleThreaded=true)
    public void deployUnDeployBPMNPackage() throws Exception {
        this.init();
        ActivitiRestClient tester = new ActivitiRestClient((String)this.bpsServer.getInstance().getPorts().get("http"), (String)this.bpsServer.getInstance().getHosts().get("default"));
        String filePath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "bpmn" + File.separator + "HelloApprove.bar";
        String fileName = "HelloApprove.bar";
        String[] deploymentResponse = new String[]{};
        String[] deploymentCheckResponse = new String[]{};
        String deploymentStatus = "";
        try {
            deploymentResponse = tester.deployBPMNPackage(filePath, fileName);
            Assert.assertTrue((String)"Deployment was not successful", (boolean)deploymentResponse[0].contains("201"));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)("Failed to Deploy bpmn package " + fileName), exception);
            Assert.fail((String)("Failed to Deploy bpmn package " + fileName));
        }
        try {
            deploymentCheckResponse = tester.getDeploymentInfoById(deploymentResponse[1]);
            Assert.assertTrue((String)"Deployment does not exist", (boolean)deploymentCheckResponse[2].contains(fileName));
        }
        catch (IOException | JSONException | RestClientException exception) {
            log.error((Object)("Deployed bpmn package " + fileName + " not present"), exception);
            Assert.fail((String)("Deployed bpmn package " + fileName + " not present"));
        }
        try {
            deploymentStatus = tester.unDeployBPMNPackage(deploymentResponse[1]);
            Assert.assertTrue((String)"Package cannot be undeployed", (boolean)deploymentStatus.contains("204"));
        }
        catch (IOException exception) {
            log.error((Object)("BPMN Package cannot be undeployed " + fileName), (Throwable)exception);
            Assert.fail((String)("BPMN Package cannot be undeployed " + fileName));
        }
        try {
            tester.getDeploymentInfoById(deploymentResponse[1]);
            Assert.fail((String)"Package Still exists after undeployment");
        }
        catch (IOException | JSONException | RestClientException exception) {
            Assert.assertTrue((String)("Bpmn package " + fileName + "does not exist"), (boolean)"Not Available".equals(exception.getMessage()));
        }
    }
}

