/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn.rest;

import junit.framework.Assert;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.tests.bpmn.BPMNTestUtils;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNProcess;
import org.wso2.carbon.bpmn.stub.BPMNDeploymentServiceStub;

public class BPMNRestDeploymentsTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPMNRestDeploymentsTestCase.class);
    private WorkflowServiceClient workflowServiceClient;
    String domainKey1 = "wso2.com";
    String userKey1 = "user1";
    private String deploymentUrl = "repository/deployments";

    @BeforeTest
    public void init() throws Exception {
        super.init();
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        this.loginLogoutClient.login();
    }

    @AfterTest
    public void removeArtifacts() throws Exception {
        this.workflowServiceClient.undeploy("oneTaskProcess");
        this.workflowServiceClient.undeploy("HelloApprove");
        this.workflowServiceClient.undeploy("VacationRequest");
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="get deployments", priority=1, singleThreaded=true)
    public void testGetDeployments() throws Exception {
        int compare;
        int i;
        int deploymentCount = 0;
        if (this.workflowServiceClient.getDeployments() != null) {
            deploymentCount = this.workflowServiceClient.getDeployments().length;
        }
        this.uploadBPMNForTest("oneTaskProcess");
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "oneTaskProcess.bar", deploymentCount);
        this.uploadBPMNForTest("HelloApprove");
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "HelloApprove", this.workflowServiceClient.getDeployments().length);
        String result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl);
        JSONObject jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/deployments:total test", (int)this.workflowServiceClient.getDeployments().length, (int)jsonObject.getInt("total"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "?name=" + "HelloApprove");
        jsonObject = new JSONObject(result);
        String deploymentName = ((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getString("name");
        Assert.assertEquals((String)"repository/deployments name query test", (String)"HelloApprove", (String)deploymentName);
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "?nameLike=" + "Task");
        jsonObject = new JSONObject(result);
        super.init(this.domainKey1, this.userKey1);
        this.loginLogoutClient.login();
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        this.uploadBPMNForTest("VacationRequest");
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "VacationRequest", 0);
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "?tenantId=" + "1");
        jsonObject = new JSONObject(result);
        String tenantId = ((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getString("tenantId");
        deploymentName = ((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getString("name");
        Assert.assertEquals((String)"repository/deployments tenantId query test", (int)this.workflowServiceClient.getDeployments().length, (int)jsonObject.getInt("total"));
        Assert.assertEquals((String)"repository/deployments tenantId query test", (String)"1", (String)tenantId);
        Assert.assertEquals((String)"repository/deployments tenantId query test", (String)"VacationRequest", (String)deploymentName);
        this.init();
        this.loginLogoutClient.login();
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "?withoutTenantId=true");
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/deployments withoutTenantId query test", (String)"0", (String)jsonObject.getString("total"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "?sort=name&order=asc");
        jsonObject = new JSONObject(result);
        JSONArray array = (JSONArray)jsonObject.get("data");
        for (i = 1; i < jsonObject.getInt("size"); ++i) {
            compare = ((JSONObject)array.get(i - 1)).getString("name").compareTo(((JSONObject)array.get(i)).getString("name"));
            Assert.assertTrue((String)"repository/deployments sort=name,order=asc query test", (compare < 0 ? 1 : 0) != 0);
        }
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "?sort=name&order=desc");
        jsonObject = new JSONObject(result);
        array = (JSONArray)jsonObject.get("data");
        for (i = 1; i < jsonObject.getInt("size"); ++i) {
            compare = ((JSONObject)array.get(i - 1)).getString("name").compareTo(((JSONObject)array.get(i)).getString("name"));
            Assert.assertTrue((String)"repository/deployments sort=name,order=asc query test", (compare > 0 ? 1 : 0) != 0);
        }
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "?sort=name&order=asc&start=1&size=2");
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/deployments paging query test", (String)"2", (String)jsonObject.getString("size"));
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="get single deployment", priority=1, singleThreaded=true)
    public void testGetSingleDeployment() throws Exception {
        this.uploadBPMNForTest("oneTaskProcess");
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "oneTaskProcess", 0);
        String deploymentId = null;
        for (int i = 0; i < this.workflowServiceClient.getDeployments().length; ++i) {
            if (!this.workflowServiceClient.getDeployments()[i].getDeploymentName().equals("oneTaskProcess")) continue;
            deploymentId = this.workflowServiceClient.getDeployments()[i].getDeploymentId();
        }
        String result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "/" + deploymentId);
        JSONObject jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/deployments/{deploymentId} test", (Object)deploymentId, (Object)jsonObject.get("id"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "/" + deploymentId + "/resources");
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/deployments/{deploymentId}/resources test", (int)2, (int)((JSONArray)jsonObject.get("deploymentResourceResponseList")).length());
        Assert.assertEquals((String)"repository/deployments/{deploymentId}/resources test", (String)"processDefinition", (String)((JSONObject)((JSONArray)jsonObject.get("deploymentResourceResponseList")).get(0)).getString("type"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + this.deploymentUrl + "/" + deploymentId + "/resources/" + "oneTaskProcess.bpmn20.xml");
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/deployments/{deploymentId}/resources/{resourceId} test", (String)"oneTaskProcess.bpmn20.xml", (String)jsonObject.getString("id"));
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="get process definitions", priority=1, singleThreaded=true)
    public void testGetProcessDefinitions() throws Exception {
        this.uploadBPMNForTest("oneTaskProcess");
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "oneTaskProcess", 0);
        BPMNProcess[] bpmnProcesses = this.workflowServiceClient.getProcesses();
        HttpResponse resultResponse = BPMNTestUtils.getRequestResponse(this.backEndUrl + "repository/process-definitions");
        BPMNDeploymentServiceStub stub = new BPMNDeploymentServiceStub(this.backEndUrl + "BPMNDeploymentService");
        AuthenticateStubUtil.authenticateStub((String)this.sessionCookie, (Stub)stub);
        stub.getDeployedProcesses();
        Assert.assertEquals((String)"repository/process-definitions test", (int)200, (int)resultResponse.getStatusLine().getStatusCode());
        String result = BPMNTestUtils.getRequest(this.backEndUrl + "repository/process-definitions/" + bpmnProcesses[0].getProcessId());
        JSONObject jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/process-definitions/{definitionId} test", (String)bpmnProcesses[0].getProcessId(), (String)jsonObject.getString("id"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + "repository/process-definitions/" + bpmnProcesses[0].getProcessId() + "/resourcedata");
        Assert.assertNotNull((Object)result);
        String oneTaskProcessId = null;
        for (int i = 0; i < bpmnProcesses.length; ++i) {
            if (!bpmnProcesses[i].getKey().equals("oneTaskProcess")) continue;
            oneTaskProcessId = bpmnProcesses[i].getProcessId();
        }
        result = BPMNTestUtils.getRequest(this.backEndUrl + "repository/process-definitions/" + oneTaskProcessId + "/identitylinks");
        result = "{resultArray:" + result + "}";
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/process-definitions/{definitionId}/identitylinks test", (int)2, (int)((JSONArray)jsonObject.get("resultArray")).length());
        Assert.assertTrue((String)"repository/process-definitions/{definitionId}/identitylinks test", (boolean)jsonObject.toString().contains("\"user\":\"kermit\""));
        Assert.assertTrue((String)"repository/process-definitions/{definitionId}/identitylinks test", (boolean)jsonObject.toString().contains("\"group\":\"admin\""));
        result = BPMNTestUtils.getRequest(this.backEndUrl + "repository/process-definitions/" + oneTaskProcessId + "/identitylinks" + "/users/kermit");
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/process-definitions/{definitionId}/identitylinks/{familly}/{identityId} test", (String)"kermit", (String)jsonObject.getString("user"));
        result = BPMNTestUtils.getRequest(this.backEndUrl + "repository/process-definitions/" + oneTaskProcessId + "/identitylinks" + "/groups/admin");
        jsonObject = new JSONObject(result);
        Assert.assertEquals((String)"repository/process-definitions/{definitionId}/identitylinks/{familly}/{identityId} test", (String)"admin", (String)jsonObject.getString("group"));
    }
}

