/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn.rest;

import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.tests.bpmn.BPMNTestUtils;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNProcess;

public class BPMNRestTasksTest
extends BPSMasterTest {
    WorkflowServiceClient workflowServiceClient;
    public static final String tasksUrl = "runtime/tasks";

    @BeforeTest
    public void init() throws Exception {
        super.init();
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        this.loginLogoutClient.login();
        this.uploadBPMNForTest("oneTaskProcess");
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, "oneTaskProcess", this.workflowServiceClient.getDeployments().length);
    }

    @Test(groups={"wso2.bps.bpmn.rest"}, description="get tasks", priority=1, singleThreaded=true)
    public void testGetTasks() throws Exception {
        String processId = null;
        for (BPMNProcess process : this.workflowServiceClient.getProcesses()) {
            if (!process.getKey().equals("oneTaskProcess")) continue;
            processId = process.getProcessId();
            this.workflowServiceClient.getInstanceServiceStub().startProcess(processId);
            break;
        }
        HttpResponse response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl);
        JSONObject jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"runtime/tasks test", (int)200, (int)response.getStatusLine().getStatusCode());
        Assert.assertTrue((String)"runtime/tasks test", (jsonObject.getInt("total") > 0 ? 1 : 0) != 0);
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl + "?name=my+task");
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"runtime/tasks?name= test", (String)"my task", (String)((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getString("name"));
        this.workflowServiceClient.getInstanceServiceStub().startProcess(processId);
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl + "?order=desc");
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertTrue((String)"runtime/tasks?order=desc test", (((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getInt("id") > ((JSONObject)((JSONArray)jsonObject.get("data")).get(1)).getInt("id") ? 1 : 0) != 0);
        int taskId = ((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getInt("id");
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl + "/" + taskId);
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"runtime/tasks/{taskId} test", (int)taskId, (int)jsonObject.getInt("id"));
        String updateBody = "{\"owner\":\"owner\", \"priority\":\"20\"}";
        response = BPMNTestUtils.putRequest(this.backEndUrl + tasksUrl + "/" + taskId, new JSONObject(updateBody));
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"PUT runtime/tasks/{taskId} test", (int)20, (int)jsonObject.getInt("priority"));
        Assert.assertEquals((String)"PUT runtime/tasks/{taskId} test", (String)"owner", (String)jsonObject.getString("owner"));
        response = BPMNTestUtils.putRequest(this.backEndUrl + tasksUrl + "/0", new JSONObject(updateBody));
        Assert.assertEquals((String)"PUT runtime/tasks/{taskId} test", (int)404, (int)response.getStatusLine().getStatusCode());
        String claimRequest = "{\"action\":\"claim\",\"assignee\":\"userWhoClaims\"}";
        response = BPMNTestUtils.postRequest(this.backEndUrl + tasksUrl + "/" + taskId, new JSONObject(claimRequest));
        Assert.assertEquals((String)"POST runtime/tasks/{taskId}  claim test", (int)200, (int)response.getStatusLine().getStatusCode());
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl + "/" + taskId);
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"POST runtime/tasks/{taskId}  claim test", (String)"userWhoClaims", (String)jsonObject.getString("assignee"));
        String delegateRequest = "{\"action\":\"delegate\",\"assignee\":\"delegatedUser\"}";
        response = BPMNTestUtils.postRequest(this.backEndUrl + tasksUrl + "/" + taskId, new JSONObject(delegateRequest));
        Assert.assertEquals((String)"POST runtime/tasks/{taskId}  delegate test", (int)200, (int)response.getStatusLine().getStatusCode());
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl + "/" + taskId);
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"POST runtime/tasks/{taskId}  claim test", (String)"delegatedUser", (String)jsonObject.getString("assignee"));
        String resolve = "{\"action\":\"resolve\"}";
        response = BPMNTestUtils.postRequest(this.backEndUrl + tasksUrl + "/" + taskId, new JSONObject(resolve));
        Assert.assertEquals((String)"POST runtime/tasks/{taskId}  resolve test", (int)200, (int)response.getStatusLine().getStatusCode());
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl + "/" + taskId);
        jsonObject = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)"POST runtime/tasks/{taskId}  claim test", (String)"owner", (String)jsonObject.getString("assignee"));
        claimRequest = "{\"action\":\"claim\"}";
        BPMNTestUtils.postRequest(this.backEndUrl + tasksUrl + "/" + taskId, new JSONObject(claimRequest));
        String complete = "{\"action\":\"complete\"}";
        response = BPMNTestUtils.postRequest(this.backEndUrl + tasksUrl + "/" + taskId, new JSONObject(complete));
        Assert.assertEquals((String)"POST runtime/tasks/{taskId}  resolve test", (int)200, (int)response.getStatusLine().getStatusCode());
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl + "/" + taskId);
        Assert.assertEquals((String)"POST runtime/tasks/{taskId}  claim test", (int)404, (int)response.getStatusLine().getStatusCode());
        this.workflowServiceClient.getInstanceServiceStub().startProcess(processId);
        String result = BPMNTestUtils.getRequest(this.backEndUrl + tasksUrl);
        jsonObject = new JSONObject(result);
        taskId = ((JSONObject)((JSONArray)jsonObject.get("data")).get(0)).getInt("id");
        response = BPMNTestUtils.deleteRequest(this.backEndUrl + tasksUrl + "/" + taskId);
        Assert.assertEquals((String)"DELETE runtime/tasks/{taskId}  claim test", (int)200, (int)response.getStatusLine().getStatusCode());
        response = BPMNTestUtils.getRequestResponse(this.backEndUrl + tasksUrl + "/" + taskId);
        Assert.assertEquals((String)"DELETE runtime/tasks/{taskId}  claim test", (int)404, (int)response.getStatusLine().getStatusCode());
    }
}

