/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpmn.rest;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpmn.WorkflowServiceClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.tests.bpmn.BPMNTestUtils;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNInstance;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNProcess;
import org.wso2.carbon.bpmn.stub.BPMNInstanceServiceStub;

public class BPMNRestVariableTestCase
extends BPSMasterTest {
    private WorkflowServiceClient workflowServiceClient;
    private BPMNInstance targetProcessInstance;
    private String taskId;
    private String targetExecutionId;
    private static final String BPMNTestPackageName = "oneTaskProcess";
    private static final Log log = LogFactory.getLog(BPMNRestVariableTestCase.class);
    private static final String variable1Name = "testvar1";
    private static final String variable2Name = "testvar2";
    private static final String taskVariableName = "taskVar2";
    private static final String execVariableName = "execVar";
    private static final String instanceUrl = "runtime/process-instances";
    private static final String taskUrl = "runtime/tasks";
    private static final String executionUrl = "runtime/executions";

    @BeforeTest
    protected void init() throws Exception {
        super.init();
        this.workflowServiceClient = new WorkflowServiceClient(this.backEndUrl, this.sessionCookie);
        this.loginLogoutClient.login();
        this.uploadBPMNForTest(BPMNTestPackageName);
        int deploymentCount = 0;
        if (this.workflowServiceClient.getDeployments() != null) {
            deploymentCount = this.workflowServiceClient.getDeployments().length;
        }
        BPMNTestUtils.waitForProcessDeployment(this.workflowServiceClient, BPMNTestPackageName, deploymentCount);
        BPMNInstance[] bpmnInstances = this.startProcessInstance(BPMNTestPackageName);
        Assert.assertNotNull((Object)bpmnInstances, (String)"BPMN process instance creation failed");
        Assert.assertEquals((int)bpmnInstances.length, (int)1, (String)"More than one instance get created");
        log.info((Object)("Process instance creation success. Instance ID: " + bpmnInstances[0].getInstanceId()));
        this.targetProcessInstance = bpmnInstances[0];
    }

    @AfterTest(alwaysRun=true)
    public void removeArtifacts() throws Exception {
        this.workflowServiceClient.undeploy(BPMNTestPackageName);
    }

    @Test(groups={"wso2.bps.bpmn.rest.variableTest"}, description="test variable creation with charset", priority=1, singleThreaded=true)
    public void testCreateVariables() throws Exception {
        String createVarRequest = "[\n    { \n      \"name\":\"testvar1\",\n      \"type\":\"integer\",\n      \"value\":15000 \n    },\n    { \n      \"name\":\"testvar2\",\n      \"type\":\"string\",\n      \"value\":\"test Variable text\" \n    }\n]";
        String postUrl = this.backEndUrl + instanceUrl + "/" + this.targetProcessInstance.getInstanceId() + "/variables";
        HttpResponse response = BPMNTestUtils.postRequest(postUrl, new JSONArray(createVarRequest));
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)201, (String)("Variable creation failed. Casue : " + response.getStatusLine().getReasonPhrase()));
    }

    @Test(groups={"wso2.bps.bpmn.rest.variableTest"}, description="test variable update with charset", priority=2, singleThreaded=true)
    public void testUpdateMultipleVariables() throws JSONException, IOException {
        int newVar1Value = 10000;
        String newVar2Value = "test Variable text updated";
        String createVarRequest = "[\n    { \n      \"name\":\"testvar1\",\n      \"type\":\"integer\",\n      \"value\":" + newVar1Value + " \n" + "    },\n" + "    { \n" + "      \"name\":\"" + variable2Name + "\",\n" + "      \"type\":\"string\",\n" + "      \"value\":\"" + newVar2Value + "\" \n" + "    }\n" + "]";
        String putUrl = this.backEndUrl + instanceUrl + "/" + this.targetProcessInstance.getInstanceId() + "/variables";
        HttpResponse response = BPMNTestUtils.putRequest(putUrl, new JSONArray(createVarRequest));
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)201, (String)("Variable update failed. Cause : " + response.getStatusLine().getReasonPhrase()));
        String var1GetUrl = this.backEndUrl + instanceUrl + "/" + this.targetProcessInstance.getInstanceId() + "/variables/" + variable1Name;
        response = BPMNTestUtils.getRequestResponse(var1GetUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)("Variable retrieval failed. Cause:" + response.getStatusLine().getReasonPhrase()));
        JSONObject responseJsonObj = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((int)responseJsonObj.getInt("value"), (int)newVar1Value, (String)"Variable content update failed");
        String var2GetUrl = this.backEndUrl + instanceUrl + "/" + this.targetProcessInstance.getInstanceId() + "/variables/" + variable2Name;
        response = BPMNTestUtils.getRequestResponse(var2GetUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)("Variable retrieval failed. Cause:" + response.getStatusLine().getReasonPhrase()));
        responseJsonObj = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)responseJsonObj.getString("value"), (String)newVar2Value, (String)"Variable content update failed");
    }

    @Test(groups={"wso2.bps.bpmn.rest.variableTest"}, description="test single variable update with charset", priority=3, singleThreaded=true)
    public void testUpdateSingleVariable() throws JSONException, IOException {
        int newVar1Value = 20000;
        String createVarRequest = "    { \n      \"name\":\"testvar1\",\n      \"type\":\"integer\",\n      \"value\":" + newVar1Value + " \n" + "    }\n";
        String putUrl = this.backEndUrl + instanceUrl + "/" + this.targetProcessInstance.getInstanceId() + "/variables/" + variable1Name;
        HttpResponse response = BPMNTestUtils.putRequest(putUrl, new JSONObject(createVarRequest));
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)("Variable update failed. Cause : " + response.getStatusLine().getReasonPhrase()));
        String var1GetUrl = this.backEndUrl + instanceUrl + "/" + this.targetProcessInstance.getInstanceId() + "/variables/" + variable1Name;
        response = BPMNTestUtils.getRequestResponse(var1GetUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)("Variable retrieval failed. Cause:" + response.getStatusLine().getReasonPhrase()));
        JSONObject responseJsonObj = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((int)responseJsonObj.getInt("value"), (int)newVar1Value, (String)"Variable content update failed");
    }

    @Test(groups={"wso2.bps.bpmn.rest.variableTest"}, description="test creating task variables with charset", priority=4, singleThreaded=true)
    public void testCreateTaskVariables() throws IOException, JSONException {
        String requestUrl = this.backEndUrl + taskUrl + "?processInstanceId=" + this.targetProcessInstance.getInstanceId();
        HttpResponse response = BPMNTestUtils.getRequestResponse(requestUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Task retrieval failed");
        JSONObject taskInfo = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        JSONArray taskList = (JSONArray)taskInfo.get("data");
        this.taskId = ((JSONObject)taskList.get(0)).getString("id");
        Assert.assertNotNull((Object)this.taskId, (String)"Task Id retrieval failed");
        String requestPayload = "[\n  {\n    \"name\" : \"taskVar2\",\n    \"scope\" : \"local\",\n    \"type\" : \"string\",\n    \"value\" : \"This is task variable text\"\n  }\n]";
        requestUrl = this.backEndUrl + taskUrl + "/" + this.taskId + "/variables";
        response = BPMNTestUtils.postRequest(requestUrl, new JSONArray(requestPayload));
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)201, (String)"Task variable creation failed");
        requestUrl = this.backEndUrl + taskUrl + "/" + this.taskId + "/variables/" + taskVariableName;
        response = BPMNTestUtils.getRequestResponse(requestUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Variable retrieval failed");
        JSONObject responsePayload = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)responsePayload.getString("value"), (String)"This is task variable text", (String)"Variable value is not set correctly");
    }

    @Test(groups={"wso2.bps.bpmn.rest.variableTest"}, description="test creating task variables with charset", priority=5, singleThreaded=true)
    public void testUpdateSingleTaskVariable() throws JSONException, IOException {
        String requestUrl = this.backEndUrl + taskUrl + "/" + this.taskId + "/variables/" + taskVariableName;
        String requestPayload = "  {\n    \"name\" : \"taskVar2\",\n    \"scope\" : \"local\",\n    \"type\" : \"string\",\n    \"value\" : \"This is task variable text UPDATE\"\n  }\n";
        HttpResponse response = BPMNTestUtils.putRequest(requestUrl, new JSONObject(requestPayload));
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)("Variable update failed. Cause : " + response.getStatusLine().getReasonPhrase()));
        requestUrl = this.backEndUrl + taskUrl + "/" + this.taskId + "/variables/" + taskVariableName;
        response = BPMNTestUtils.getRequestResponse(requestUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Variable retrieval failed");
        JSONObject responsePayload = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)responsePayload.getString("value"), (String)"This is task variable text UPDATE", (String)"Variable value is not set correctly");
    }

    @Test(groups={"wso2.bps.bpmn.rest.variableTest"}, description="test creating task variables with charset", priority=6, singleThreaded=true)
    public void testCreateExecutionVariable() throws IOException, JSONException {
        String requestUrl = this.backEndUrl + executionUrl + "?processInstanceId=" + this.targetProcessInstance.getInstanceId();
        HttpResponse response = BPMNTestUtils.getRequestResponse(requestUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Variable retrieval failed");
        JSONObject responsePayload = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        JSONArray responseData = responsePayload.getJSONArray("data");
        Assert.assertNotNull((Object)responseData, (String)"Execution list empty");
        Assert.assertEquals((int)responseData.length(), (int)1, (String)"Expected number of execution not found");
        this.targetExecutionId = responseData.getJSONObject(0).getString("id");
        Assert.assertNotNull((Object)this.targetExecutionId, (String)"Unable to retieve execution ID");
        requestUrl = this.backEndUrl + executionUrl + "/" + this.targetExecutionId + "/variables";
        String requestPayload = "[\n  {\n    \"name\" : \"execVar\",\n    \"scope\" : \"local\",\n    \"type\" : \"string\",\n    \"value\" : \"This is execution variable text\"\n  }\n]";
        response = BPMNTestUtils.postRequest(requestUrl, new JSONArray(requestPayload));
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)201, (String)"Execution variable creation failed");
        requestUrl = this.backEndUrl + executionUrl + "/" + this.targetExecutionId + "/variables/" + execVariableName;
        response = BPMNTestUtils.getRequestResponse(requestUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Variable retrieval failed");
        responsePayload = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)responsePayload.getString("value"), (String)"This is execution variable text", (String)"Variable value is not set correctly");
    }

    @Test(groups={"wso2.bps.bpmn.rest.variableTest"}, description="test creating task variables with charset", priority=7, singleThreaded=true)
    public void testUpdateExecutionVariables() throws JSONException, IOException {
        String requestUrl = this.backEndUrl + executionUrl + "/" + this.targetExecutionId + "/variables";
        String requestPayload = "[\n  {\n    \"name\" : \"execVar\",\n    \"scope\" : \"local\",\n    \"type\" : \"string\",\n    \"value\" : \"This is execution variable text UPDATE\"\n  }\n]";
        HttpResponse response = BPMNTestUtils.putRequest(requestUrl, new JSONArray(requestPayload));
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)201, (String)"Execution variable update failed");
        requestUrl = this.backEndUrl + executionUrl + "/" + this.targetExecutionId + "/variables/" + execVariableName;
        response = BPMNTestUtils.getRequestResponse(requestUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Variable retrieval failed");
        JSONObject responsePayload = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)responsePayload.getString("value"), (String)"This is execution variable text UPDATE", (String)"Variable value is not updated correctly");
    }

    @Test(groups={"wso2.bps.bpmn.rest.variableTest"}, description="test creating task variables with charset", priority=8, singleThreaded=true)
    public void testUpdateSingleExecutionVariables() throws JSONException, IOException {
        String requestUrl = this.backEndUrl + executionUrl + "/" + this.targetExecutionId + "/variables/" + execVariableName;
        String requestPayload = "  {\n    \"name\" : \"execVar\",\n    \"scope\" : \"local\",\n    \"type\" : \"string\",\n    \"value\" : \"This is execution variable text UPDATE 2\"\n  }\n";
        HttpResponse response = BPMNTestUtils.putRequest(requestUrl, new JSONObject(requestPayload));
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)201, (String)"Execution variable update failed");
        requestUrl = this.backEndUrl + executionUrl + "/" + this.targetExecutionId + "/variables/" + execVariableName;
        response = BPMNTestUtils.getRequestResponse(requestUrl);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Variable retrieval failed");
        JSONObject responsePayload = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        Assert.assertEquals((String)responsePayload.getString("value"), (String)"This is execution variable text UPDATE 2", (String)"Variable value is not updated correctly");
    }

    private BPMNInstance[] startProcessInstance(String processId) throws Exception {
        BPMNProcess[] processes = this.workflowServiceClient.getProcesses();
        BPMNInstanceServiceStub bpmnInstanceService = this.workflowServiceClient.getInstanceServiceStub();
        BPMNInstance[] instances = bpmnInstanceService.getProcessInstances();
        int previousInstanceCount = instances == null ? 0 : instances.length;
        for (BPMNProcess process : processes) {
            if (!process.getProcessId().split(":")[0].equals(processId)) continue;
            bpmnInstanceService.startProcess(process.getProcessId());
            break;
        }
        if ((instances = bpmnInstanceService.getProcessInstances()).length > previousInstanceCount) {
            return instances;
        }
        return null;
    }
}

