/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.humantasks;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.axis2.databinding.types.NCName;
import org.apache.axis2.databinding.types.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.humantasks.HumanTaskClientApiClient;
import org.wso2.bps.integration.common.clients.humantasks.HumanTaskPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.humantask.stub.mgt.types.HumanTaskPackageDownloadData;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TComment;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TPriority;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryCategory;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryInput;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskAbstract;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskEvent;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskEvents;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultRow;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultSet;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;

public class HumanTaskCreationTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(HumanTaskCreationTestCase.class);
    private BpelPackageManagementClient bpelPackageManagementClient;
    private HumanTaskPackageManagementClient humanTaskPackageManagementClient;
    private BpelInstanceManagementClient instanceManagementClient;
    private UserManagementClient userManagementClient;
    private HumanTaskClientApiClient clerk1HumanTaskClientApiClient;
    private HumanTaskClientApiClient manager1HumanTaskClientApiClient;
    private RequestSender requestSender;
    private URI taskId = null;
    private Set<String> taskEvents = new HashSet<String>();

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.humanTaskPackageManagementClient = new HumanTaskPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
        this.initialize();
        AutomationContext clerk1AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "clerk1");
        LoginLogoutClient clerk1LoginLogoutClient = new LoginLogoutClient(clerk1AutomationContext);
        String clerk1SessionCookie = clerk1LoginLogoutClient.login();
        this.clerk1HumanTaskClientApiClient = new HumanTaskClientApiClient(this.backEndUrl, clerk1SessionCookie);
        AutomationContext manager1AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "manager1");
        LoginLogoutClient manager1LoginLogoutClient = new LoginLogoutClient(manager1AutomationContext);
        String manager1SessionCookie = manager1LoginLogoutClient.login();
        this.manager1HumanTaskClientApiClient = new HumanTaskClientApiClient(this.backEndUrl, manager1SessionCookie);
    }

    protected void initialize() throws Exception {
        log.info((Object)"Initializing HumanTask task creation Test...");
        this.userManagementClient = new UserManagementClient(this.backEndUrl, this.sessionCookie);
        this.addRoles();
        this.instanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.humanTaskPackageManagementClient = new HumanTaskPackageManagementClient(this.backEndUrl, this.sessionCookie);
        log.info((Object)"Add users success !");
        this.deployArtifact();
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "ClaimsApprovalProcessService");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "ClaimService");
    }

    public void deployArtifact() throws Exception {
        this.uploadBpelForTest("ClaimsApprovalProcess");
        this.uploadHumanTaskForTest("ClaimsApprovalTask");
    }

    private void addRoles() throws Exception {
        String[] clerkUsers = new String[]{"clerk1", "clerk2", "clerk3"};
        String[] managerUsers = new String[]{"manager1", "manager2", "manager3"};
        this.userManagementClient.addRole("regionalClerksRole", clerkUsers, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        this.userManagementClient.addRole("regionalManagerRole", managerUsers, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
    }

    @Test(groups={"wso2.bps.task.create"}, description="Claims approval test case", priority=1, singleThreaded=true)
    public void createFirstTask() throws Exception {
        String soapBody = "<p:ClaimApprovalData xmlns:p=\"http://www.example.com/claims/schema\">\n      <p:cust>\n         <p:id>235235</p:id>\n         <p:firstname>sanjaya</p:firstname>\n         <p:lastname>vithanagama</p:lastname>\n      </p:cust>\n      <p:amount>2500</p:amount>\n      <p:region>LK</p:region>\n      <p:priority>7</p:priority>\n      <p:activateAt>2012-12-09T01:01:01</p:activateAt>\n</p:ClaimApprovalData>";
        String operation = "approve";
        String serviceName = "ClaimService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("taskid>");
        log.info((Object)("Calling Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, soapBody, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps.task.create"}, description="Claims approval test case", priority=2, singleThreaded=true)
    public void createSecondTask() throws Exception {
        String soapBody = "<p:ClaimApprovalData xmlns:p=\"http://www.example.com/claims/schema\">\n      <p:cust>\n         <p:id>452422</p:id>\n         <p:firstname>John</p:firstname>\n         <p:lastname>Doe</p:lastname>\n      </p:cust>\n      <p:amount>50000</p:amount>\n      <p:region>US</p:region>\n      <p:priority>1</p:priority>\n      <p:activateAt>2012-12-09T01:01:01</p:activateAt>\n</p:ClaimApprovalData>";
        String operation = "approve";
        String serviceName = "ClaimService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("taskid>");
        log.info((Object)("Calling Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, soapBody, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps.task.create"}, description="Claims approval B4P test case", priority=3, singleThreaded=true)
    public void createTaskB4P() throws Exception {
        String soapBody = "<cla:ClaimApprovalProcessInput xmlns:cla=\"http://www.wso2.org/humantask/claimsapprovalprocessservice.wsdl\">\n         <cla:custID>C002</cla:custID>\n         <cla:custFName>Waruna</cla:custFName>\n         <cla:custLName>Ranasinghe</cla:custLName>\n         <cla:amount>10000</cla:amount>\n         <cla:region>Gampaha</cla:region>\n         <cla:priority>2</cla:priority>\n      </cla:ClaimApprovalProcessInput>";
        String operation = "claimsApprovalProcessOperation";
        String serviceName = "ClaimsApprovalProcessService";
        List expectedOutput = Collections.emptyList();
        log.info((Object)("Calling Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, soapBody, 1, expectedOutput, false);
        Thread.sleep(5000L);
        this.instanceManagementClient.listInstances("{http://www.wso2.org/humantask/claimsapprovalprocess.bpel}ClaimsApprovalProcess", 1);
        TSimpleQueryInput queryInput = new TSimpleQueryInput();
        queryInput.setPageNumber(0);
        queryInput.setSimpleQueryCategory(TSimpleQueryCategory.ALL_TASKS);
        TTaskSimpleQueryResultSet taskResults = this.clerk1HumanTaskClientApiClient.simpleQuery(queryInput);
        TTaskSimpleQueryResultRow[] rows = taskResults.getRow();
        TTaskSimpleQueryResultRow b4pTask = null;
        Assert.assertNotNull((Object)rows, (String)"No tasks found. Task creation has failed. ");
        for (TTaskSimpleQueryResultRow row : rows) {
            if (b4pTask == null) {
                b4pTask = row;
                continue;
            }
            if (Long.parseLong(b4pTask.getId().toString()) >= Long.parseLong(row.getId().toString())) continue;
            b4pTask = row;
        }
        Assert.assertNotNull(b4pTask, (String)"Task creation has failed");
        String claimApprovalRequest = (String)this.clerk1HumanTaskClientApiClient.getInput(b4pTask.getId(), null);
        Assert.assertNotNull((Object)claimApprovalRequest, (String)("The input of the Task:" + b4pTask.getId() + " is null."));
        Assert.assertFalse((!claimApprovalRequest.contains("C002") ? 1 : 0) != 0, (String)"Unexpected input found for the Task");
        this.clerk1HumanTaskClientApiClient.claim(b4pTask.getId());
        this.clerk1HumanTaskClientApiClient.start(b4pTask.getId());
        this.clerk1HumanTaskClientApiClient.complete(b4pTask.getId(), "<sch:ClaimApprovalResponse xmlns:sch=\"http://www.example.com/claims/schema\">\n         <sch:approved>true</sch:approved>\n      </sch:ClaimApprovalResponse>");
        Thread.sleep(5000L);
        List instances = this.instanceManagementClient.listInstances("{http://www.wso2.org/humantask/claimsapprovalprocess.bpel}ClaimsApprovalProcess", 1);
        this.instanceManagementClient.assertStatus("COMPLETED", instances);
        this.instanceManagementClient.assertVariable("b4pOutput", ">true<", instances);
        this.instanceManagementClient.deleteAllInstances();
    }

    @Test(groups={"wso2.bps.task.operate.list"}, description="Simple Query Test", priority=4, singleThreaded=true)
    public void testSimpleTaskQuery() throws Exception {
        TSimpleQueryInput queryInput = new TSimpleQueryInput();
        queryInput.setPageNumber(0);
        queryInput.setSimpleQueryCategory(TSimpleQueryCategory.ALL_TASKS);
        TTaskSimpleQueryResultSet allTasksList = this.clerk1HumanTaskClientApiClient.simpleQuery(queryInput);
        TTaskSimpleQueryResultRow[] rows = allTasksList.getRow();
        int taskIdInt = Integer.MAX_VALUE;
        for (TTaskSimpleQueryResultRow row : rows) {
            int rowTaskId = Integer.parseInt(row.getId().toString());
            if (rowTaskId >= taskIdInt) continue;
            taskIdInt = rowTaskId;
            this.taskId = row.getId();
        }
        Assert.assertNotNull((Object)rows, (String)"The task results cannot be null");
        Assert.assertEquals((int)rows.length, (int)3, (String)"There should be 3 tasks from the query");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Load Task Test", priority=5, singleThreaded=true)
    public void testLoadTask() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        TTaskAbstract loadedTask = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertNotNull((Object)loadedTask, (String)"The task is not created successfully");
        Assert.assertEquals((String)loadedTask.getId().toString(), (String)this.taskId.toString(), (String)"The task id is wrong");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Claim Task Test", priority=6, singleThreaded=true)
    public void taskClaimTask() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        this.clerk1HumanTaskClientApiClient.claim(this.taskId);
        TTaskAbstract loadedTask = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertEquals((String)loadedTask.getActualOwner().getTUser(), (String)"clerk1", (String)"The assignee should be clerk1 !");
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"RESERVED", (String)"The task status should be RESERVED!");
        this.taskEvents.add("claim");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Task Start without Claim Test", priority=7, singleThreaded=true)
    public void testTaskStartWithoutClaim() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        this.clerk1HumanTaskClientApiClient.release(this.taskId);
        this.clerk1HumanTaskClientApiClient.start(this.taskId);
        TTaskAbstract loadedTask = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"IN_PROGRESS", (String)"The task status should be IN_PROGRESS!");
        this.clerk1HumanTaskClientApiClient.stop(this.taskId);
        this.clerk1HumanTaskClientApiClient.release(this.taskId);
        this.clerk1HumanTaskClientApiClient.claim(this.taskId);
        loadedTask = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertNotNull((Object)loadedTask.getActualOwner(), (String)"After claim the task the actual owner should be not null");
        Assert.assertEquals((String)"clerk1", (String)loadedTask.getActualOwner().getTUser(), (String)"Actual owner should be clerk1");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Claims approval test case release and reclaim task", priority=8, singleThreaded=true)
    public void taskReleaseAndReClaimTask() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        this.clerk1HumanTaskClientApiClient.release(this.taskId);
        TTaskAbstract loadedTask = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertNull((Object)loadedTask.getActualOwner(), (String)"After releasing the task the actual owner should be null");
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"READY", (String)"The task status should be READY!");
        this.taskEvents.add("release");
        this.clerk1HumanTaskClientApiClient.claim(this.taskId);
        TTaskAbstract loadedTaskAferReClaim = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertEquals((String)loadedTaskAferReClaim.getActualOwner().getTUser(), (String)"clerk1", (String)"The assignee should be clerk1 !");
        Assert.assertEquals((String)loadedTaskAferReClaim.getStatus().toString(), (String)"RESERVED", (String)"The task status should be RESERVED!");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Get Task input test", priority=9, singleThreaded=true)
    public void testTaskGetInput() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        String input = (String)this.clerk1HumanTaskClientApiClient.getInput(this.taskId, null);
        Assert.assertNotNull((Object)input, (String)"The input message cannot be null");
        Assert.assertTrue((boolean)input.contains("<ClaimApprovalData xmlns=\"http://www.example.com/claims/schema\" xmlns:p=\"http://www.example.com/claims/schema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">"), (String)"The retrieved input message should contain message data");
        NCName ncName = new NCName();
        ncName.setValue("ClaimApprovalRequest");
        String inputMessageWithPartName = (String)this.clerk1HumanTaskClientApiClient.getInput(this.taskId, ncName);
        Assert.assertNotNull((Object)input, (String)"The input message cannot be null");
        Assert.assertTrue((boolean)input.contains("<ClaimApprovalData xmlns=\"http://www.example.com/claims/schema\" xmlns:p=\"http://www.example.com/claims/schema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">"), (String)"The retrieved input message should contain message data");
        Assert.assertEquals((String)input, (String)inputMessageWithPartName, (String)"2 returned values are different");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Start Task test", priority=10, singleThreaded=true)
    public void testStartTask() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        this.clerk1HumanTaskClientApiClient.start(this.taskId);
        TTaskAbstract loadedTask = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"IN_PROGRESS", (String)"The task status should be IN_PROGRESS after starting the task!");
        this.taskEvents.add("start");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Task priority change test case", priority=11, singleThreaded=true)
    public void testChangeTaskPriority() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        TPriority newPriority1 = new TPriority();
        newPriority1.setTPriority(BigInteger.valueOf(1L));
        this.manager1HumanTaskClientApiClient.setPriority(this.taskId, newPriority1);
        TTaskAbstract taskAfterPriorityChange1 = this.manager1HumanTaskClientApiClient.loadTask(this.taskId);
        TPriority prio1 = taskAfterPriorityChange1.getPriority();
        int newPriority1Int = prio1.getTPriority().intValue();
        Assert.assertEquals((int)newPriority1Int, (int)1, (String)"The new priority should be 1 after the set priority operation");
        TPriority newPriority2 = new TPriority();
        newPriority2.setTPriority(BigInteger.valueOf(10L));
        this.manager1HumanTaskClientApiClient.setPriority(this.taskId, newPriority2);
        TTaskAbstract taskAfterPriorityChange2 = this.manager1HumanTaskClientApiClient.loadTask(this.taskId);
        TPriority prio2 = taskAfterPriorityChange2.getPriority();
        int newPriority2Int = prio2.getTPriority().intValue();
        Assert.assertEquals((int)newPriority2Int, (int)10, (String)"The new priority should be 10 after the set priority operation");
        TPriority newPriority3 = new TPriority();
        newPriority3.setTPriority(BigInteger.valueOf(0L));
        this.manager1HumanTaskClientApiClient.setPriority(this.taskId, newPriority3);
        TTaskAbstract taskAfterPriorityChange3 = this.manager1HumanTaskClientApiClient.loadTask(this.taskId);
        newPriority3 = taskAfterPriorityChange3.getPriority();
        int newPriority3Int = newPriority3.getTPriority().intValue();
        Assert.assertEquals((int)newPriority3Int, (int)0, (String)"The new priority should be 0 after the set priority operation");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Stop task test case", priority=12, singleThreaded=true)
    public void testStopTask() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        this.clerk1HumanTaskClientApiClient.stop(this.taskId);
        TTaskAbstract loadedTask = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"RESERVED", (String)"The task status should be RESERVED after stopping the task!");
        this.taskEvents.add("stop");
        this.clerk1HumanTaskClientApiClient.start(this.taskId);
        TTaskAbstract loadedTask2 = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertEquals((String)loadedTask2.getStatus().toString(), (String)"IN_PROGRESS", (String)"The task status should be IN_PROGRESS after re-starting the task!");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Suspend task test case", priority=13, singleThreaded=true)
    public void testSuspendAndResume() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        this.clerk1HumanTaskClientApiClient.suspend(this.taskId);
        TTaskAbstract loadedTask = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"SUSPENDED", (String)"The task status should be SUSPENDED after suspending the task!");
        Assert.assertEquals((String)loadedTask.getPreviousStatus().toString(), (String)"IN_PROGRESS", (String)"The task previous status should be IN_PROGRESS");
        this.taskEvents.add("suspend");
        this.clerk1HumanTaskClientApiClient.resume(this.taskId);
        TTaskAbstract loadedTaskAfterResume = this.clerk1HumanTaskClientApiClient.loadTask(this.taskId);
        Assert.assertEquals((String)loadedTaskAfterResume.getStatus().toString(), (String)"IN_PROGRESS", (String)"The task status should be IN_PROGRESS after resuming the suspended task!");
        this.taskEvents.add("resume");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Comment on a task test case", priority=14, singleThreaded=true)
    public void testTaskCommentOperations() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        String commentText1 = "This is a test comment";
        URI taskCommentId = this.clerk1HumanTaskClientApiClient.addComment(this.taskId, commentText1);
        this.taskEvents.add("addcomment");
        Assert.assertNotNull((Object)taskCommentId, (String)"The comment id cannot be null");
        TComment[] taskComments = this.clerk1HumanTaskClientApiClient.getComments(this.taskId);
        Assert.assertEquals((int)taskComments.length, (int)1, (String)"The task comments size should be 1 after adding only 1 comment");
        Assert.assertEquals((Object)taskComments[0].getId(), (Object)taskCommentId, (String)"The task comment id returned should be equal");
        String commentText2 = "This is a test comment 2";
        URI taskCommentId2 = this.clerk1HumanTaskClientApiClient.addComment(this.taskId, commentText2);
        Assert.assertNotNull((Object)taskCommentId2, (String)"The comment id cannot be null");
        TComment[] taskComments2 = this.clerk1HumanTaskClientApiClient.getComments(this.taskId);
        Assert.assertEquals((int)taskComments2.length, (int)2, (String)"The task comments size should be 2 after adding 2 comments");
        Assert.assertEquals((Object)taskComments2[1].getId(), (Object)taskCommentId2, (String)"The task comment id returned should be equal");
        this.clerk1HumanTaskClientApiClient.deleteComment(this.taskId, taskCommentId);
        TComment[] commentsAfterDeletion = this.clerk1HumanTaskClientApiClient.getComments(this.taskId);
        Assert.assertEquals((int)commentsAfterDeletion.length, (int)1, (String)"Only 1 comment should be left");
        Assert.assertEquals((Object)commentsAfterDeletion[0].getId(), (Object)taskCommentId2, (String)"Only comment 2 should be left after deleting comment 1");
        this.clerk1HumanTaskClientApiClient.deleteComment(this.taskId, taskCommentId2);
        TComment[] commentsAfterAllDeletions = this.clerk1HumanTaskClientApiClient.getComments(this.taskId);
        Assert.assertNull((Object)commentsAfterAllDeletions, (String)"There should not be any comments left!");
        this.taskEvents.add("deletecomment");
    }

    @Test(groups={"wso2.bps.task.operate"}, description="Task event persistence", priority=15, singleThreaded=true)
    public void testTaskEventHistory() throws Exception {
        Assert.assertNotNull((Object)this.taskId, (String)"The task ID has to be set by now!");
        TTaskEvents tTaskEvents = this.clerk1HumanTaskClientApiClient.loadTaskEvents(this.taskId);
        TTaskEvent[] events = tTaskEvents.getEvent();
        Assert.assertNotNull((Object)events, (String)"The task event history cannot be empty after performing task operations");
        Assert.assertNotEquals((Object)events.length, (Object)0, (String)"The task event history objects should be a positive number");
        HashSet<String> persistedTaskEvents = new HashSet<String>();
        for (TTaskEvent event : events) {
            persistedTaskEvents.add(event.getEventType());
        }
        for (String occurredTaskEvent : this.taskEvents) {
            Assert.assertTrue((boolean)persistedTaskEvents.contains(occurredTaskEvent), (String)("The occurred task event [" + occurredTaskEvent + "] is not in the persisted task event list :[" + StringUtils.join((Object[])persistedTaskEvents.toArray(), (String)",") + "]"));
        }
    }

    @Test(groups={"wso2.bps.task.operate"}, description="package download test case", priority=16, singleThreaded=true)
    public void testDownloadPackage() throws Exception {
        HumanTaskPackageDownloadData downloadData = this.humanTaskPackageManagementClient.downloadHumanTaskPackage("ClaimsApprovalTask");
        Assert.assertNotNull((Object)downloadData.getPackageFileData(), (String)"The downloaded package data cannot be null");
        Assert.assertEquals((String)downloadData.getPackageName(), (String)"ClaimsApprovalTask.zip");
    }

    @Test(groups={"wso2.bps.task.clean"}, description="Clean up server", priority=17, singleThreaded=true)
    public void removeArtifacts() throws Exception {
        this.userManagementClient.deleteRole("regionalClerksRole");
        this.userManagementClient.deleteRole("regionalManagerRole");
        Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalClerksRole"));
        Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalManagerRole"));
        this.bpelPackageManagementClient.undeployBPEL("ClaimsApprovalProcess");
        this.humanTaskPackageManagementClient.unDeployHumanTask("ClaimsApprovalTask", "ApproveClaim");
        this.loginLogoutClient.logout();
    }
}

