/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.humantasks;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.humantasks.HumanTaskPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.bps.integration.tests.humantasks.HumanTaskCreationTestCase;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.humantask.stub.mgt.PackageManagementException;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class HumanTaskNotificationsTestCase
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(HumanTaskCreationTestCase.class);
    private HumanTaskPackageManagementClient humanTaskPackageManagementClient;
    private UserManagementClient userManagementClient;
    private ServerConfigurationManager serverConfigurationManager;
    private RequestSender requestSender;
    private static GreenMail mailServer;
    private static final String USER_PASSWORD = "testwso2123";
    private static final String USER_NAME = "wso2test1";
    private static final String EMAIL_USER_ADDRESS = "wso2test1@localhost";
    private static final String EMAIL_SUBJECT = "email subject to user";
    private static final String EMAIL_TEXT = "Hi wso2test1";
    private static final int SMTP_TEST_PORT = 3025;
    GreenMail greenMail;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.init();
        this.requestSender = new RequestSender();
        this.serverConfigurationManager = new ServerConfigurationManager(this.bpsServer);
        this.updateConfigFiles();
        this.init();
        this.userManagementClient = new UserManagementClient(this.backEndUrl, this.sessionCookie);
        this.deployArtifact();
        this.addRoles();
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "ClaimReminderService");
        this.humanTaskPackageManagementClient = new HumanTaskPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.serverConfigurationManager = new ServerConfigurationManager(this.bpsServer);
        log.info((Object)"Server setting up completed.");
        AutomationContext clerk1AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "clerk1");
        LoginLogoutClient clerk1LoginLogoutClient = new LoginLogoutClient(clerk1AutomationContext);
        clerk1LoginLogoutClient.login();
        AutomationContext manager1AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "manager1");
        LoginLogoutClient manager1LoginLogoutClient = new LoginLogoutClient(manager1AutomationContext);
        manager1LoginLogoutClient.login();
        ServerSetup setup = new ServerSetup(3025, "localhost", "smtp");
        this.greenMail = new GreenMail(setup);
        this.greenMail.setUser(EMAIL_USER_ADDRESS, USER_NAME, USER_PASSWORD);
        this.greenMail.start();
    }

    private void updateConfigFiles() throws Exception {
        String artifactLocation = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "config" + File.separator + "email" + File.separator;
        File humantaskConfigNew = new File(artifactLocation + "humantask.xml");
        File humantaskConfigOriginal = new File(FrameworkPathUtil.getCarbonServerConfLocation() + File.separator + "humantask.xml");
        this.serverConfigurationManager.applyConfiguration(humantaskConfigNew, humantaskConfigOriginal, true, false);
        File humanTaskAxis2ClientConfigNew = new File(artifactLocation + "axis2_client.xml");
        File humanTaskAxis2ClientConfigOriginal = new File(FrameworkPathUtil.getCarbonServerConfLocation() + File.separator + "axis2" + File.separator + "axis2_client.xml");
        this.serverConfigurationManager.applyConfiguration(humanTaskAxis2ClientConfigNew, humanTaskAxis2ClientConfigOriginal, true, true);
    }

    public void deployArtifact() throws Exception {
        this.uploadHumanTaskForTest("taskDeadlineWithNotificationsTest");
    }

    private void addRoles() {
        try {
            String[] clerkUsers = new String[]{"clerk1"};
            String[] managerUsers = new String[]{"manager1"};
            this.userManagementClient.addRole("regionalClerksRole", clerkUsers, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
            this.userManagementClient.addRole("regionalManagerRole", managerUsers, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        }
        catch (RemoteException e) {
            log.error((Object)e);
        }
        catch (UserAdminUserAdminException e) {
            log.error((Object)e);
        }
    }

    @Test(groups={"wso2.bps.task.create"}, description="Claims approval notification support test case", priority=1, singleThreaded=true)
    public void createTaskWithNotifications() {
        try {
            String soapBody = "<p:notify xmlns:p=\"http://www.example.com/claims/\">\n<firstname>John</firstname>\n<lastname>Denver</lastname>\n</p:notify>";
            String operation = "notify";
            String serviceName = "ClaimReminderService";
            List expectedOutput = Collections.emptyList();
            log.info((Object)("Calling Service: " + this.backEndUrl + serviceName));
            this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, soapBody, 1, expectedOutput, false);
            this.greenMail.waitForIncomingEmail(5000L, 1);
            MimeMessage[] messages = this.greenMail.getReceivedMessages();
            Assert.assertNotNull((Object)messages.length);
            Assert.assertEquals((String)messages[0].getSubject(), (String)EMAIL_SUBJECT);
            Assert.assertTrue((boolean)String.valueOf(messages[0].getContent()).contains(EMAIL_TEXT));
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
        catch (MessagingException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    @Test(groups={"wso2.bps.task.clean"}, description="Clean up server notifications", priority=17, singleThreaded=true)
    public void removeArtifacts() {
        try {
            this.greenMail.stop();
            log.info((Object)"Undeploy claim reminder service");
            this.userManagementClient.deleteRole("regionalClerksRole");
            this.userManagementClient.deleteRole("regionalManagerRole");
            Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalClerksRole"));
            Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalManagerRole"));
            this.humanTaskPackageManagementClient.unDeployHumanTask("ClaimReminderService", "notify");
            this.loginLogoutClient.logout();
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
        catch (RemoteException e) {
            log.error((Object)e);
        }
        catch (LogoutAuthenticationExceptionException e) {
            log.error((Object)e);
        }
        catch (PackageManagementException e) {
            log.error((Object)e);
        }
        catch (UserAdminUserAdminException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

