/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.humantasks;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.humantasks.HumanTaskClientApiClient;
import org.wso2.bps.integration.common.clients.humantasks.HumanTaskPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TPriority;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryCategory;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryInput;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskAbstract;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultRow;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultSet;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;

public class HumanTaskPeopleAssignment
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(HumanTaskPeopleAssignment.class);
    private HumanTaskClientApiClient clerk1Client;
    private HumanTaskClientApiClient clerk2Client;
    private HumanTaskClientApiClient clerk3Client;
    private HumanTaskClientApiClient manager1Client;
    private HumanTaskClientApiClient manager3Client;
    private HumanTaskPackageManagementClient humanTaskPackageManagementClient;
    private UserManagementClient userManagementClient;
    private RequestSender requestSender;
    private URI taskID = null;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.init();
        this.humanTaskPackageManagementClient = new HumanTaskPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
        this.initialize();
        AutomationContext clerk1AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "clerk1");
        LoginLogoutClient clerk1LoginLogoutClient = new LoginLogoutClient(clerk1AutomationContext);
        String clerk1SessionCookie = clerk1LoginLogoutClient.login();
        this.clerk1Client = new HumanTaskClientApiClient(this.backEndUrl, clerk1SessionCookie);
        AutomationContext clerk2AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "clerk2");
        LoginLogoutClient clerk2LoginLogoutClient = new LoginLogoutClient(clerk2AutomationContext);
        String clerk2SessionCookie = clerk2LoginLogoutClient.login();
        this.clerk2Client = new HumanTaskClientApiClient(this.backEndUrl, clerk2SessionCookie);
        AutomationContext clerk3AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "clerk3");
        LoginLogoutClient clerk3LoginLogoutClient = new LoginLogoutClient(clerk3AutomationContext);
        String clerk3SessionCookie = clerk3LoginLogoutClient.login();
        this.clerk3Client = new HumanTaskClientApiClient(this.backEndUrl, clerk3SessionCookie);
        AutomationContext manager1AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "manager1");
        LoginLogoutClient manager1LoginLogoutClient = new LoginLogoutClient(manager1AutomationContext);
        String manager1SessionCookie = manager1LoginLogoutClient.login();
        this.manager1Client = new HumanTaskClientApiClient(this.backEndUrl, manager1SessionCookie);
        AutomationContext manager3AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "manager3");
        LoginLogoutClient manager3LoginLogoutClient = new LoginLogoutClient(manager3AutomationContext);
        String manager3SessionCookie = manager3LoginLogoutClient.login();
        this.manager3Client = new HumanTaskClientApiClient(this.backEndUrl, manager3SessionCookie);
    }

    @BeforeGroups(groups={"wso2.bps.task.people.assignment"})
    protected void initialize() throws Exception {
        log.info((Object)"Initializing HumanTask task creation Test...");
        this.userManagementClient = new UserManagementClient(this.backEndUrl, this.sessionCookie);
        this.addRoles();
        this.humanTaskPackageManagementClient = new HumanTaskPackageManagementClient(this.backEndUrl, this.sessionCookie);
        log.info((Object)"Add users success !");
        this.deployArtifact();
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "ClaimService");
    }

    public void deployArtifact() throws Exception {
        String artifactLocation = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "humantask" + File.separator + "peopleAssignmentTest" + File.separator + "test1";
        this.uploadHumanTaskForTest("ClaimsApprovalOrgEntity", artifactLocation);
    }

    private void addRoles() throws Exception {
        String[] rc1 = new String[]{"clerk1", "clerk2", "clerk3"};
        String[] rc2 = new String[]{"clerk3", "clerk4", "clerk5"};
        String[] rc3 = new String[]{"clerk4", "clerk5", "clerk6"};
        String[] rm1 = new String[]{"manager1", "manager2"};
        String[] rm2 = new String[]{"manager2", "manager3"};
        this.userManagementClient.addRole("regionalClerksRole", rc1, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        this.userManagementClient.addRole("regionalClerksRole2", rc2, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        this.userManagementClient.addRole("regionalClerksRole3", rc3, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        this.userManagementClient.addRole("regionalManagerRole", rm1, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask"}, false);
        this.userManagementClient.addRole("regionalManagerRole2", rm2, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask"}, false);
    }

    @Test(groups={"wso2.bps.task.createTask"}, description="Create Task 1", priority=1, singleThreaded=true)
    public void createTask() throws Exception {
        String soapBody = "<sch:ClaimApprovalData xmlns:sch=\"http://www.example.com/claims/schema\" xmlns:ns=\"http://docs.oasis-open.org/ns/bpel4people/ws-humantask/types/200803\">\n         <sch:cust>\n            <sch:id>123</sch:id>\n            <sch:firstname>Hasitha</sch:firstname>\n            <sch:lastname>Aravinda</sch:lastname>\n            <sch:owners>\n               <ns:group>regionalClerksRole</ns:group>\n            </sch:owners>\n            <sch:excludedOwners>\n               <ns:user>clerk3</ns:user>\n            </sch:excludedOwners>\n            <sch:globleAdmins>\n               <ns:group>regionalManagerRole</ns:group>\n            </sch:globleAdmins>\n            <sch:regionalAdmins>\n               <ns:group>regionalManagerRole2</ns:group>\n            </sch:regionalAdmins>\n         </sch:cust>\n         <sch:amount>2500</sch:amount>\n         <sch:region>lk</sch:region>\n         <sch:priority>7</sch:priority>\n      </sch:ClaimApprovalData>";
        String operation = "approve";
        String serviceName = "ClaimService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("taskid>");
        log.info((Object)("Calling Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, soapBody, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps.task.createTask"}, description="Check created Task", priority=2, singleThreaded=true)
    public void checkCreatedTask() throws Exception {
        TSimpleQueryInput queryInput = new TSimpleQueryInput();
        queryInput.setPageNumber(0);
        queryInput.setSimpleQueryCategory(TSimpleQueryCategory.CLAIMABLE);
        TTaskSimpleQueryResultSet taskResults = this.clerk1Client.simpleQuery(queryInput);
        TTaskSimpleQueryResultRow[] rows = taskResults.getRow();
        Assert.assertNotNull((Object)rows, (String)"No tasks found. Task creation has failed. ");
        Assert.assertTrue((rows.length == 1 ? 1 : 0) != 0, (String)("There should be only one claimable task in the engine, but found " + rows.length + " tasks."));
    }

    @Test(groups={"wso2.bps.task.claim"}, description="Clerk1 claim task", priority=3, singleThreaded=true)
    public void clerk1Claim() throws Exception {
        TSimpleQueryInput queryInput = new TSimpleQueryInput();
        queryInput.setPageNumber(0);
        queryInput.setSimpleQueryCategory(TSimpleQueryCategory.CLAIMABLE);
        TTaskSimpleQueryResultSet taskResults = this.clerk1Client.simpleQuery(queryInput);
        TTaskSimpleQueryResultRow[] rows = taskResults.getRow();
        TTaskSimpleQueryResultRow b4pTask = rows[0];
        this.taskID = b4pTask.getId();
        this.clerk1Client.claim(this.taskID);
        TTaskAbstract loadedTask = this.clerk1Client.loadTask(this.taskID);
        Assert.assertEquals((String)loadedTask.getActualOwner().getTUser(), (String)"clerk1", (String)"The assignee should be clerk1 !");
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"RESERVED", (String)"The task status should be RESERVED!");
    }

    @Test(groups={"wso2.bps.task.claim"}, description="Clerk2 claim task which is RESERVED", priority=4, singleThreaded=true, expectedExceptions={AxisFault.class})
    public void clerk2Claim() throws Exception {
        this.clerk2Client.claim(this.taskID);
    }

    @Test(groups={"wso2.bps.task.claim"}, description="Clerk1 release task", priority=5, singleThreaded=true)
    public void clerk1Release() throws Exception {
        this.clerk1Client.release(this.taskID);
        TTaskAbstract loadedTask = this.clerk1Client.loadTask(this.taskID);
        Assert.assertNull((Object)loadedTask.getActualOwner(), (String)"Task has an actual owner. Task Release failed");
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"READY", (String)"The task status should be READY!");
    }

    @Test(groups={"wso2.bps.task.claim"}, description="Clerk2 re-claim task and release", priority=6, singleThreaded=true)
    public void clerk2ReClaimAndRelease() throws Exception {
        this.clerk2Client.claim(this.taskID);
        TTaskAbstract loadedTask = this.clerk2Client.loadTask(this.taskID);
        Assert.assertEquals((String)loadedTask.getActualOwner().getTUser(), (String)"clerk2", (String)"The assignee should be clerk2 !");
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"RESERVED", (String)"The task status should be RESERVED!");
        this.clerk2Client.release(this.taskID);
        loadedTask = this.clerk2Client.loadTask(this.taskID);
        Assert.assertNull((Object)loadedTask.getActualOwner(), (String)"Task has an actual owner. Task Release failed");
        Assert.assertEquals((String)loadedTask.getStatus().toString(), (String)"READY", (String)"The task status should be READY!");
    }

    @Test(groups={"wso2.bps.task.claim"}, description="Clerk3 (an excluded owner) try to claim", priority=7, singleThreaded=true, expectedExceptions={AxisFault.class})
    public void clerk3Claim() throws Exception {
        this.clerk3Client.claim(this.taskID);
    }

    @Test(groups={"wso2.bps.task.xpath.union"}, description="Test Xpath operation -Union", priority=10, singleThreaded=true)
    public void testUnion() throws Exception {
        this.loginLogoutClient.logout();
        TPriority tPriority = new TPriority();
        tPriority.setTPriority(BigInteger.valueOf(2L));
        this.manager1Client.setPriority(this.taskID, tPriority);
        TTaskAbstract taskAfterPriorityChange1 = this.manager1Client.loadTask(this.taskID);
        TPriority prio1 = taskAfterPriorityChange1.getPriority();
        int newPriority1Int = prio1.getTPriority().intValue();
        Assert.assertEquals((int)newPriority1Int, (int)2, (String)"The new priority should be 2 after the set priority operation");
        tPriority = new TPriority();
        tPriority.setTPriority(BigInteger.valueOf(3L));
        this.manager3Client.setPriority(this.taskID, tPriority);
        taskAfterPriorityChange1 = this.manager3Client.loadTask(this.taskID);
        TPriority prio2 = taskAfterPriorityChange1.getPriority();
        int newPriority1Int2 = prio2.getTPriority().intValue();
        Assert.assertEquals((int)newPriority1Int2, (int)3, (String)"The new priority should be 3 after the set priority operation");
    }

    @Test(groups={"wso2.bps.task.clean"}, description="Clean up server", priority=100, singleThreaded=true)
    public void cleanTestEnvironment() throws Exception {
        this.userManagementClient.deleteRole("regionalClerksRole");
        this.userManagementClient.deleteRole("regionalClerksRole2");
        this.userManagementClient.deleteRole("regionalClerksRole3");
        this.userManagementClient.deleteRole("regionalManagerRole");
        this.userManagementClient.deleteRole("regionalManagerRole2");
        Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalClerksRole"));
        Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalClerksRole2"));
        Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalClerksRole3"));
        Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalManagerRole"));
        Assert.assertFalse((boolean)this.userManagementClient.roleNameExists("regionalManagerRole2"));
        this.humanTaskPackageManagementClient.unDeployHumanTask("ClaimsApprovalOrgEntity", "ApproveClaim");
        this.loginLogoutClient.logout();
    }
}

