/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.humantasks;

import java.io.File;
import java.util.ArrayList;
import org.apache.axis2.databinding.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.humantasks.HumanTaskClientApiClient;
import org.wso2.bps.integration.common.clients.humantasks.HumanTaskPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.bps.integration.tests.humantasks.HumanTaskPeopleAssignment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryCategory;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryInput;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskAbstract;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultRow;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultSet;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;

public class HumanTaskXpathExtensionsTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(HumanTaskPeopleAssignment.class);
    private HumanTaskClientApiClient clerk1Client;
    private HumanTaskClientApiClient clerk2Client;
    private HumanTaskClientApiClient clerk3Client;
    private HumanTaskClientApiClient manager1Client;
    private HumanTaskClientApiClient manager3Client;
    private HumanTaskPackageManagementClient humanTaskPackageManagementClient;
    private UserManagementClient userManagementClient;
    private RequestSender requestSender;
    private URI taskID = null;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.init();
        this.humanTaskPackageManagementClient = new HumanTaskPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
        this.initialize();
        AutomationContext clerk1AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "clerk1");
        LoginLogoutClient clerk1LoginLogoutClient = new LoginLogoutClient(clerk1AutomationContext);
        String clerk1SessionCookie = clerk1LoginLogoutClient.login();
        this.clerk1Client = new HumanTaskClientApiClient(this.backEndUrl, clerk1SessionCookie);
        AutomationContext clerk2AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "clerk2");
        LoginLogoutClient clerk2LoginLogoutClient = new LoginLogoutClient(clerk2AutomationContext);
        String clerk2SessionCookie = clerk2LoginLogoutClient.login();
        this.clerk2Client = new HumanTaskClientApiClient(this.backEndUrl, clerk2SessionCookie);
        AutomationContext clerk3AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "clerk3");
        LoginLogoutClient clerk3LoginLogoutClient = new LoginLogoutClient(clerk3AutomationContext);
        String clerk3SessionCookie = clerk3LoginLogoutClient.login();
        this.clerk3Client = new HumanTaskClientApiClient(this.backEndUrl, clerk3SessionCookie);
        AutomationContext manager1AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "manager1");
        LoginLogoutClient manager1LoginLogoutClient = new LoginLogoutClient(manager1AutomationContext);
        String manager1SessionCookie = manager1LoginLogoutClient.login();
        this.manager1Client = new HumanTaskClientApiClient(this.backEndUrl, manager1SessionCookie);
        AutomationContext manager3AutomationContext = new AutomationContext("BPS", "bpsServerInstance0001", "superTenant", "manager3");
        LoginLogoutClient manager3LoginLogoutClient = new LoginLogoutClient(manager3AutomationContext);
        String manager3SessionCookie = manager3LoginLogoutClient.login();
        this.manager3Client = new HumanTaskClientApiClient(this.backEndUrl, manager3SessionCookie);
        this.createTask();
    }

    @BeforeGroups(groups={"wso2.bps.task.people.assignment"})
    protected void initialize() throws Exception {
        log.info((Object)"Initializing HumanTask task creation Test...");
        this.userManagementClient = new UserManagementClient(this.backEndUrl, this.sessionCookie);
        this.addRoles();
        this.humanTaskPackageManagementClient = new HumanTaskPackageManagementClient(this.backEndUrl, this.sessionCookie);
        log.info((Object)"Add users success !");
        this.humanTaskPackageManagementClient.unDeployHumanTask("ClaimsApprovalOrgEntity", "ApproveClaim");
        this.deployArtifact();
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "ClaimService");
    }

    public void deployArtifact() throws Exception {
        String artifactLocation = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "humantask" + File.separator + "peopleAssignmentTest" + File.separator + "test6";
        this.uploadHumanTaskForTest("ClaimsApprovalOrgEntity", artifactLocation);
    }

    private void addRoles() throws Exception {
        String[] rc1 = new String[]{"clerk1", "clerk2", "clerk3"};
        String[] rc2 = new String[]{"clerk3", "clerk4", "clerk5"};
        String[] rc3 = new String[]{"clerk4", "clerk5", "clerk6"};
        String[] rm1 = new String[]{"manager1", "manager2"};
        String[] rm2 = new String[]{"manager2", "manager3"};
        this.userManagementClient.addRole("regionalClerksRole", rc1, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        this.userManagementClient.addRole("regionalClerksRole2", rc2, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        this.userManagementClient.addRole("regionalClerksRole3", rc3, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        this.userManagementClient.addRole("regionalManagerRole", rm1, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask"}, false);
        this.userManagementClient.addRole("regionalManagerRole2", rm2, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask"}, false);
    }

    private void createTask() throws Exception {
        String soapBody = "<sch:ClaimApprovalData xmlns:sch=\"http://www.example.com/claims/schema\" xmlns:ns=\"http://docs.oasis-open.org/ns/bpel4people/ws-humantask/types/200803\">\n         <sch:cust>\n            <sch:id>123</sch:id>\n            <sch:initial>A</sch:initial>\n            <sch:initial>B</sch:initial>\n            <sch:initial>C</sch:initial>\n            <sch:firstname>Hasitha</sch:firstname>\n            <sch:lastname>Aravinda</sch:lastname>\n            <sch:othername>name1</sch:othername>            <sch:othername>name2</sch:othername>            <sch:othername>name3</sch:othername>            <sch:custRegion>LK</sch:custRegion>            <sch:custRegion>UK</sch:custRegion>            <sch:custRegion>LK</sch:custRegion>            <sch:custRegion>LK</sch:custRegion>            <sch:custRegion>UK</sch:custRegion>            <sch:custRegion>US</sch:custRegion>            <sch:custRegion>IN</sch:custRegion>            <sch:custRegion>DK</sch:custRegion>            <sch:custRegion>DK</sch:custRegion>            <sch:custArrears>arr_DK</sch:custArrears>            <sch:custArrears>arr_DK</sch:custArrears>            <sch:custArrears>arr_DK</sch:custArrears>            <sch:custArrears>arr_LK</sch:custArrears>            <sch:custArrears>arr_LK</sch:custArrears>            <sch:custArrears>arr_LK</sch:custArrears>            <sch:custArrears>arr_UK</sch:custArrears>            <sch:custArrears>arr_UK</sch:custArrears>            <sch:custArrears>arr_SW</sch:custArrears>            <sch:boolTrue>true</sch:boolTrue>            <sch:boolTrue>1</sch:boolTrue>            <sch:boolTrue>TRUE</sch:boolTrue>            <sch:boolTrue>True</sch:boolTrue>            <sch:boolFalse>false</sch:boolFalse>            <sch:boolFalse>0</sch:boolFalse>            <sch:boolFalse>False</sch:boolFalse>            <sch:boolFalse>FALSE</sch:boolFalse>            <sch:boolMix>FALSE</sch:boolMix>            <sch:boolMix>true</sch:boolMix>            <sch:boolMix>0</sch:boolMix>            <sch:boolMix>1</sch:boolMix>            <sch:boolMix>1</sch:boolMix>            <sch:amount>2500</sch:amount>            <sch:amount>2000</sch:amount>            <sch:amount>500</sch:amount>            <sch:amount>-500</sch:amount>            <sch:amount>4000</sch:amount>            <sch:amount>3500</sch:amount>            <sch:owners>\n               <ns:group>regionalClerksRole</ns:group>\n            </sch:owners>\n            <sch:excludedOwners>\n               <ns:user>clerk3</ns:user>\n            </sch:excludedOwners>\n            <sch:globleAdmins>\n               <ns:group>regionalManagerRole</ns:group>\n            </sch:globleAdmins>\n            <sch:regionalAdmins>\n               <ns:group>regionalManagerRole2</ns:group>\n            </sch:regionalAdmins>\n         </sch:cust>\n         <sch:amount>2500</sch:amount>\n         <sch:region>lk</sch:region>\n         <sch:priority>7</sch:priority>\n      </sch:ClaimApprovalData>";
        String operation = "approve";
        String serviceName = "ClaimService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("taskid>");
        log.info((Object)("Calling Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, soapBody, 1, expectedOutput, true);
        this.setTaskID();
    }

    private void setTaskID() throws Exception {
        TSimpleQueryInput queryInput = new TSimpleQueryInput();
        queryInput.setPageNumber(0);
        queryInput.setSimpleQueryCategory(TSimpleQueryCategory.CLAIMABLE);
        TTaskSimpleQueryResultSet taskResults = this.clerk1Client.simpleQuery(queryInput);
        TTaskSimpleQueryResultRow[] rows = taskResults.getRow();
        TTaskSimpleQueryResultRow b4pTask = rows[0];
        this.taskID = b4pTask.getId();
    }

    @Test(groups={"wso2.bps.task.xpath"}, description="Test Xpath string operations", priority=10, singleThreaded=true)
    public void testStringFunctions() throws Exception {
        TTaskAbstract humanTask = this.manager1Client.loadTask(this.taskID);
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("ABC"), (String)"Concat() method test, subject should contain ABC");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("name1 name2 name3"), (String)"concatWithDelimiter() method test, should contain name1 name2 name3");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("LK"), (String)"mostFrequentOccurence() test, should contain LK");
        Assert.assertFalse((humanTask.getPresentationSubject().getTPresentationSubject().contains("arr_DK") || humanTask.getPresentationSubject().getTPresentationSubject().contains("arr_LK") || humanTask.getPresentationSubject().getTPresentationSubject().contains("arr_UK") || humanTask.getPresentationSubject().getTPresentationSubject().contains("arr_US") ? 1 : 0) != 0, (String)"mostFrequentOccurence() test, should not contain any arr_* since a tie");
        Assert.assertTrue((boolean)humanTask.getPresentationDescription().getTPresentationDescription().contains("arr_SW"), (String)"leastFrequentOccurence() test, should contain arr_US");
        Assert.assertFalse((humanTask.getPresentationDescription().getTPresentationDescription().contains("LK") || humanTask.getPresentationDescription().getTPresentationDescription().contains("UK") || humanTask.getPresentationDescription().getTPresentationDescription().contains("IN") || humanTask.getPresentationDescription().getTPresentationDescription().contains("DK") || humanTask.getPresentationDescription().getTPresentationDescription().contains("US") ? 1 : 0) != 0, (String)"leastFrequentOccurence() test, should not contain any region since a tie");
        Assert.assertFalse((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("vote40_LK"), (String)"vote() should not return highest occurance LK, since low percentage");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("vote20_LK"), (String)"vote() should return LK");
        Assert.assertFalse((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("voteEmpty_LK"), (String)"vote() should return empty string for empty list");
    }

    @Test(groups={"wso2.bps.task.xpath"}, description="Test Xpath boolean operations", priority=10, singleThreaded=true)
    public void testBooleanFunctions() throws Exception {
        TTaskAbstract humanTask = this.manager1Client.loadTask(this.taskID);
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("andTrue_true"), (String)"and() should return true when all true");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("andFalse_false"), (String)"and() should return false when all false");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("andMix_false"), (String)"and() should return false when mix boolean inputs");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("andEmpty_false"), (String)"an() should return false when empty node set");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("orTrue_true"), (String)"or() should return true when all true");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("orFalse_false"), (String)"or() should return false when all false");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("orMix_true"), (String)"or() should return true when mix boolean inputs");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("orEmpty_false"), (String)"or()should return false when empty set");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("vote10_true"), (String)"vote() should return true since true has 60%");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("vote70_false"), (String)"vote() should return false since true has 60%");
        Assert.assertTrue((boolean)humanTask.getPresentationSubject().getTPresentationSubject().contains("vote5_false"), (String)"vote() should return false since false is highest");
    }

    @Test(groups={"wso2.bps.task.xpath"}, description="Test Xpath number operations", priority=10, singleThreaded=true)
    public void testNumberFunctions() throws Exception {
        TTaskAbstract humanTask = this.manager1Client.loadTask(this.taskID);
        Assert.assertTrue((boolean)humanTask.getPresentationDescription().getTPresentationDescription().contains("avg_2000"), (String)"avg() should return 2000");
        Assert.assertTrue((boolean)humanTask.getPresentationDescription().getTPresentationDescription().contains("min_-500"), (String)"min() should return -500");
        Assert.assertTrue((boolean)humanTask.getPresentationDescription().getTPresentationDescription().contains("max_4000"), (String)"max() should return 4000");
        Assert.assertTrue((boolean)humanTask.getPresentationDescription().getTPresentationDescription().contains("avg_NaN"), (String)"avg() should return NaN for empty list");
        Assert.assertTrue((boolean)humanTask.getPresentationDescription().getTPresentationDescription().contains("min_NaN"), (String)"min() should return NaN for empty list");
        Assert.assertTrue((boolean)humanTask.getPresentationDescription().getTPresentationDescription().contains("max_NaN"), (String)"max() should return NaN for empty list");
    }

    @AfterClass(groups={"wso2.bps.task.clean"}, description="Clean up server")
    public void cleanTestEnvironment() throws Exception {
        this.userManagementClient.deleteRole("regionalClerksRole");
        this.userManagementClient.deleteRole("regionalClerksRole2");
        this.userManagementClient.deleteRole("regionalClerksRole3");
        this.userManagementClient.deleteRole("regionalManagerRole");
        this.userManagementClient.deleteRole("regionalManagerRole2");
        this.humanTaskPackageManagementClient.unDeployHumanTask("ClaimsApprovalOrgEntity", "ApproveClaim");
        this.loginLogoutClient.logout();
    }
}

