/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.patches.bpel;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class CARBON14841TenantHTTPHeadersTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(CARBON14841TenantHTTPHeadersTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init(TestUserMode.TENANT_USER);
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true, groups={"wso2.bps.testPatches"})
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("AdminServiceInvoke");
        String domain = this.bpsServer.getContextTenant().getDomain();
        String eprUrl = this.backEndUrl + "/t/" + domain + "/AdminServiceInvoke";
        this.requestSender.waitForProcessDeployment(eprUrl);
    }

    @Test(groups={"wso2.bps", "wso2.bps.testPatches"}, description="CARBON14841TenantHTTPHeaders test case", priority=0)
    public void process() throws InterruptedException, RemoteException, PackageManagementException, MalformedURLException, XMLStreamException, XPathExpressionException {
        String payload = "   <p:AdminServiceInvokeRequest xmlns:p=\"http://wso2.org/bps/sample\">\n      <input xmlns=\"http://wso2.org/bps/sample\">test</input>\n   </p:AdminServiceInvokeRequest>";
        String operation = "process";
        String serviceName = "AdminServiceInvoke";
        String expectedOutput = "RDBMS";
        String domain = this.bpsServer.getContextTenant().getDomain();
        String eprUrl = this.backEndUrl + "/t/" + domain + "/" + serviceName;
        this.requestSender.assertRequest(eprUrl, operation, payload, 1, expectedOutput, true);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("AdminServiceInvoke");
        this.loginLogoutClient.logout();
    }
}

