/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.ui.pages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.wso2.bps.integration.ui.pages.UIElementMapper;
import org.wso2.bps.integration.ui.pages.login.LoginPage;
import org.wso2.carbon.automation.engine.configurations.UrlGenerationUtil;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.Instance;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;

public class BPSIntegrationUiBaseTest {
    private static final Log log = LogFactory.getLog(BPSIntegrationUiBaseTest.class);
    protected AutomationContext ssServer;
    protected String sessionCookie;
    protected String backendURL;
    protected LoginLogoutClient loginLogoutClient;
    protected WebDriver driver;
    private static final String PRODUCT_GROUP_NAME = "BPS";

    protected void init() throws Exception {
        this.ssServer = new AutomationContext(PRODUCT_GROUP_NAME, TestUserMode.SUPER_TENANT_ADMIN);
        this.loginLogoutClient = new LoginLogoutClient(this.ssServer);
        this.sessionCookie = this.loginLogoutClient.login();
        this.backendURL = this.ssServer.getContextUrls().getBackEndUrl();
        this.driver = BrowserManager.getWebDriver();
    }

    protected void init(TestUserMode testUserMode) throws Exception {
        this.ssServer = new AutomationContext(PRODUCT_GROUP_NAME, testUserMode);
        this.loginLogoutClient = new LoginLogoutClient(this.ssServer);
        this.sessionCookie = this.loginLogoutClient.login();
        this.backendURL = this.ssServer.getContextUrls().getBackEndUrl();
        this.driver = BrowserManager.getWebDriver();
    }

    protected String getLoginURL() throws Exception {
        return UrlGenerationUtil.getLoginURL((Instance)this.ssServer.getInstance());
    }

    protected LoginPage logout() throws Exception {
        this.driver.findElement(By.xpath((String)UIElementMapper.getInstance().getElement("home.sign.out.xpath"))).click();
        return new LoginPage(this.driver);
    }
}

