/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.ui.pages;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIElementMapper {
    private static final Properties uiProperties = new Properties();
    private static final Log log = LogFactory.getLog(UIElementMapper.class);
    private static UIElementMapper instance;

    private UIElementMapper() {
    }

    public static UIElementMapper getInstance() {
        return instance;
    }

    private static Properties setStream() throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = UIElementMapper.class.getResourceAsStream("/mapper.properties");
            if (inputStream.available() > 0) {
                uiProperties.load(inputStream);
                Properties properties = uiProperties;
                return properties;
            }
        }
        catch (IOException e) {
            String errMsg = "Cannot read the steam";
            log.error((Object)errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Couldn't close the input steam", (Throwable)e);
            }
        }
        return null;
    }

    public String getElement(String key) {
        if (uiProperties != null) {
            return uiProperties.getProperty(key);
        }
        return null;
    }

    static {
        try {
            UIElementMapper.setStream();
            instance = new UIElementMapper();
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError("mapper stream not set. Failed to read file");
        }
    }
}

