/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.ui.pages.login;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.bps.integration.ui.pages.UIElementMapper;
import org.wso2.bps.integration.ui.pages.main.HomePage;
import org.wso2.bps.integration.ui.pages.main.TenantHomePage;

public class LoginPage {
    private static final Log log = LogFactory.getLog(LoginPage.class);
    private WebDriver driver;

    public LoginPage(WebDriver driver) throws IOException {
        this.driver = driver;
        if (!driver.getCurrentUrl().contains("login.jsp")) {
            throw new IllegalStateException("This is not the login page");
        }
    }

    public HomePage loginAs(String userName, String password) throws IOException {
        log.info((Object)("Login as " + userName));
        WebElement userNameField = this.driver.findElement(By.id((String)UIElementMapper.getInstance().getElement("login.username.id")));
        WebElement passwordField = this.driver.findElement(By.id((String)UIElementMapper.getInstance().getElement("login.password.id")));
        userNameField.sendKeys(new CharSequence[]{userName});
        passwordField.sendKeys(new CharSequence[]{password});
        this.driver.findElement(By.className((String)UIElementMapper.getInstance().getElement("login.sign.in.button"))).click();
        this.driver.findElement(By.id((String)UIElementMapper.getInstance().getElement("main.tab.id"))).click();
        return new HomePage(this.driver);
    }

    public TenantHomePage loginAsTenant(String userName, String domain, String password) {
        log.info((Object)("Login as " + userName));
        WebElement userNameField = this.driver.findElement(By.id((String)UIElementMapper.getInstance().getElement("login.username.id")));
        WebElement passwordField = this.driver.findElement(By.id((String)UIElementMapper.getInstance().getElement("login.password.id")));
        userNameField.sendKeys(new CharSequence[]{userName + "@" + domain});
        passwordField.sendKeys(new CharSequence[]{password});
        this.driver.findElement(By.className((String)UIElementMapper.getInstance().getElement("login.sign.in.button"))).click();
        this.driver.findElement(By.id((String)UIElementMapper.getInstance().getElement("main.tab.id"))).click();
        return new TenantHomePage(this.driver);
    }
}

