/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.samples.processcleanup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;

public class DBQuery {
    private String ODE_PARTNER_LINK;
    private String ODE_SCOPE;
    private String ODE_EVENT;
    private String ODE_CORSET_PROP;
    private String ODE_CORRELATION_SET;
    private String ODE_XML_DATA_PROP;
    private String ODE_XML_DATA;
    private String ODE_MEX_PROP;
    private String ODE_MESSAGE;
    private String ODE_MESSAGE_EXCHANGE;
    private String ODE_MESSAGE_ROUTE;
    private String GET_INSTANCES_IDS;
    private String SEARCH;
    private String ODE_PROCESS;
    private String ODE_PROCESS_INSTANCE;
    private String STORE_DU;
    private String STORE_PROCESS;

    DBQuery(String databaseURL, String bpsHome) {
        Properties prop = new Properties();
        try {
            String configPath = bpsHome + "repository" + File.separator + "conf" + File.separator + "process-cleanup.properties";
            prop.load(new FileInputStream(configPath));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        if (databaseURL.contains("mysql") || databaseURL.contains("oracle") || databaseURL.contains("sqlserver") || databaseURL.contains("postgresql")) {
            this.SEARCH = "select distinct(s.PID) as PROCESS_ID, case when o.ID is null then \"-1\" else o.ID end as ID, s.VERSION, s.DU\nfrom STORE_PROCESS s left join ODE_PROCESS o\non s.PID = o.PROCESS_ID\nwhere s.STATE != \"ACTIVE\" {0}\nand s.DU not in \n(select distinct(s.DU)\nfrom STORE_PROCESS s left join ODE_PROCESS o\non s.PID = o.PROCESS_ID\nwhere s.STATE = \"ACTIVE\")";
            this.GET_INSTANCES_IDS = "select ID from ODE_PROCESS_INSTANCE where PROCESS_ID = \"{0}\"";
            this.ODE_EVENT = "DELETE FROM ODE_EVENT WHERE INSTANCE_ID = \"{0}\"";
            this.ODE_CORSET_PROP = "DELETE FROM ODE_CORSET_PROP WHERE CORRSET_ID IN (SELECT cs.CORRELATION_SET_ID FROM ODE_CORRELATION_SET cs WHERE cs.SCOPE_ID IN (SELECT os.SCOPE_ID FROM ODE_SCOPE os WHERE os.PROCESS_INSTANCE_ID = \"{0}\"))";
            this.ODE_CORRELATION_SET = "DELETE FROM ODE_CORRELATION_SET WHERE SCOPE_ID IN (SELECT os.SCOPE_ID FROM ODE_SCOPE os WHERE os.PROCESS_INSTANCE_ID = \"{0}\")";
            this.ODE_PARTNER_LINK = "DELETE FROM ODE_PARTNER_LINK WHERE SCOPE_ID IN (SELECT os.SCOPE_ID FROM ODE_SCOPE os WHERE os.PROCESS_INSTANCE_ID = \"{0}\")";
            this.ODE_XML_DATA_PROP = "DELETE FROM ODE_XML_DATA_PROP WHERE XML_DATA_ID IN (SELECT xd.XML_DATA_ID FROM ODE_XML_DATA xd WHERE xd.SCOPE_ID IN (SELECT os.SCOPE_ID FROM ODE_SCOPE os WHERE os.PROCESS_INSTANCE_ID = \"{0}\"))";
            this.ODE_XML_DATA = "DELETE FROM ODE_XML_DATA WHERE SCOPE_ID IN (SELECT os.SCOPE_ID FROM ODE_SCOPE os WHERE os.PROCESS_INSTANCE_ID = \"{0}\")";
            this.ODE_SCOPE = "DELETE FROM ODE_SCOPE WHERE PROCESS_INSTANCE_ID = \"{0}\"";
            this.ODE_MEX_PROP = "DELETE FROM ODE_MEX_PROP WHERE MEX_ID IN (SELECT mex.MESSAGE_EXCHANGE_ID FROM ODE_MESSAGE_EXCHANGE mex WHERE mex.PROCESS_INSTANCE_ID = \"{0}\")";
            this.ODE_MESSAGE = "DELETE FROM ODE_MESSAGE WHERE MESSAGE_EXCHANGE_ID IN (SELECT mex.MESSAGE_EXCHANGE_ID FROM ODE_MESSAGE_EXCHANGE mex WHERE mex.PROCESS_INSTANCE_ID = \"{0}\")";
            this.ODE_MESSAGE_EXCHANGE = "DELETE FROM ODE_MESSAGE_EXCHANGE WHERE PROCESS_INSTANCE_ID = \"{0}\"";
            this.ODE_MESSAGE_ROUTE = "DELETE FROM ODE_MESSAGE_ROUTE WHERE PROCESS_INSTANCE_ID = \"{0}\"";
            this.ODE_PROCESS_INSTANCE = "DELETE FROM ODE_PROCESS_INSTANCE WHERE ID = \"{0}\"";
            this.ODE_PROCESS = "delete from ODE_PROCESS where id = \"{0}\"";
            this.STORE_DU = "delete from STORE_DU where NAME=\"{0}\"";
            this.STORE_PROCESS = "delete from STORE_PROCESS where DU=\"{0}\"";
        } else if (databaseURL.contains("h2")) {
            System.out.println("H2 not yet supported.");
            System.exit(0);
        } else {
            System.out.println("Unsupported DB Type \nor Invalid Driver Name!");
        }
    }

    public String deleteFromStoreProcess(String name) {
        String sql = MessageFormat.format(this.STORE_PROCESS, name);
        return sql.replaceAll("\"", "'");
    }

    public String getSearchQuery(String filter) {
        String sql = MessageFormat.format(this.SEARCH, filter);
        return sql.replaceAll("\"", "'");
    }

    public String getSearchByNameQuery(String filter, String name) {
        String sql = MessageFormat.format(this.SEARCH, filter).concat(" and s.DU like \"%" + name + "%\"");
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeProcess(String id) {
        String sql = MessageFormat.format(this.ODE_PROCESS, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromStoreDu(String name) {
        String sql = MessageFormat.format(this.STORE_DU, name);
        return sql.replaceAll("\"", "'");
    }

    public String getInstancesSearchQuery(String processID) {
        String sql = MessageFormat.format(this.GET_INSTANCES_IDS, processID);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeProcessInstance(String id) {
        String sql = MessageFormat.format(this.ODE_PROCESS_INSTANCE, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeScope(String id) {
        String sql = MessageFormat.format(this.ODE_SCOPE, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdePartnerLink(String id) {
        String sql = MessageFormat.format(this.ODE_PARTNER_LINK, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeEvent(String id) {
        String sql = MessageFormat.format(this.ODE_EVENT, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeCorsetProp(String id) {
        String sql = MessageFormat.format(this.ODE_CORSET_PROP, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeCorrelationSet(String id) {
        String sql = MessageFormat.format(this.ODE_CORRELATION_SET, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeXmlDataProp(String id) {
        String sql = MessageFormat.format(this.ODE_XML_DATA_PROP, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeXmlData(String id) {
        String sql = MessageFormat.format(this.ODE_XML_DATA, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeMexProp(String id) {
        String sql = MessageFormat.format(this.ODE_MEX_PROP, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeMessage(String id) {
        String sql = MessageFormat.format(this.ODE_MESSAGE, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeMessageExchange(String id) {
        String sql = MessageFormat.format(this.ODE_MESSAGE_EXCHANGE, id);
        return sql.replaceAll("\"", "'");
    }

    public String deleteFromOdeMessageRoute(String id) {
        String sql = MessageFormat.format(this.ODE_MESSAGE_ROUTE, id);
        return sql.replaceAll("\"", "'");
    }
}

