/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.samples.processcleanup;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceStub;
import org.wso2.carbon.utils.NetworkUtils;

public class RegistryCleaner {
    private static Properties prop = new Properties();

    public static boolean deleteRegistry(String regPath, String packageName, String clientTrustStorePath, String trustStorePassword, String trustStoreType) {
        RegistryCleaner.setKeyStore(clientTrustStorePath, trustStorePassword, trustStoreType);
        try {
            File file = new File("." + File.separator);
            System.setProperty("carbon.home", file.getCanonicalFile().toString());
            if (System.getProperty("os.name").startsWith("Windows")) {
                prop.load(new FileInputStream(System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "conf" + File.separator + "process-cleanup.properties"));
            } else {
                prop.load(new FileInputStream(System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "conf" + File.separator + "process-cleanup.properties"));
            }
            String resourceAdminServiceURL = prop.getProperty("tenant.context") + "/services/ResourceAdminService";
            ResourceAdminServiceStub resourceAdminServiceStub = new ResourceAdminServiceStub(resourceAdminServiceURL);
            ServiceClient client = resourceAdminServiceStub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)RegistryCleaner.login());
            resourceAdminServiceStub._getServiceClient().getOptions().setTimeOutInMilliSeconds(600000L);
            String regPathAppend = regPath + packageName.split("-\\d*$")[0];
            String regPathVersionsAppend = regPathAppend + "/versions/";
            int count = resourceAdminServiceStub.getCollectionContent(regPathVersionsAppend).getChildCount();
            if (count > 1) {
                resourceAdminServiceStub.delete(regPathVersionsAppend + packageName);
                return true;
            }
            if (count == 1) {
                resourceAdminServiceStub.delete(regPathAppend);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void setKeyStore(String clientTrustStorePath, String trustStorePassword, String trustStoreType) {
        System.setProperty("javax.net.ssl.trustStore", clientTrustStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        System.setProperty("javax.net.ssl.trustStoreType", trustStoreType);
    }

    public static String login() throws Exception {
        String authenticationAdminServiceURL = prop.getProperty("tenant.context") + "/services/AuthenticationAdmin";
        AuthenticationAdminStub authenticationAdminStub = new AuthenticationAdminStub(authenticationAdminServiceURL);
        ServiceClient client = authenticationAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        String userName = prop.getProperty("wso2.bps.username");
        String password = prop.getProperty("wso2.bps.password");
        String hostName = NetworkUtils.getLocalHostname();
        authenticationAdminStub.login(userName, password, hostName);
        ServiceContext serviceContext = authenticationAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
        return (String)serviceContext.getProperty("Cookie");
    }
}

