/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.samples.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.utils.CarbonUtils;

public class SamplesInvoker {
    private static final Log log = LogFactory.getLog(SamplesInvoker.class);
    public static final String ACTION = "action";
    public static final String REQ_MSG = "requestMsg";
    public static final String SVC_NAME = "serviceName";
    private static OMElement requestPayload = null;
    private static String action = null;
    private static String serviceName = null;
    private static UserAdminStub userAdminStub = null;
    private static AuthenticationAdminStub authenticationAdminStub = null;
    static final String USER_MANAGEMENT_SERVICE_URL = "https://localhost:9443/services/UserAdmin";
    static final String AUTHENTICATION_SERVICE_URL = "https://localhost:9443/services/AuthenticationAdmin";

    private static String getProperty(String propertyName, String defaultValue) {
        String result = System.getProperty(propertyName);
        if (result == null || result.length() == 0) {
            result = defaultValue;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            SamplesInvoker.executeClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadServiceProperties(String propFilePath, String operation) {
        File f = new File(propFilePath);
        Properties properties = new Properties();
        FileInputStream fin = null;
        ByteArrayInputStream bin = null;
        String xmlStr = null;
        try {
            fin = new FileInputStream(f);
            properties.load(fin);
            serviceName = properties.getProperty(SVC_NAME).trim();
            if (operation != null && !operation.equals("")) {
                action = properties.getProperty(operation + "." + ACTION).trim();
                xmlStr = properties.getProperty(operation + "." + REQ_MSG).trim();
            } else {
                action = properties.getProperty(ACTION).trim();
                xmlStr = properties.getProperty(REQ_MSG).trim();
            }
            bin = new ByteArrayInputStream(xmlStr.getBytes());
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)bin);
            requestPayload = builder.getDocumentElement();
        }
        catch (IOException e) {
            System.out.println("Exception in reading properties file" + e.getMessage());
            System.exit(0);
        }
        catch (XMLStreamException xe) {
            System.out.println("Error in the xml request msg " + xe.getMessage());
            System.exit(0);
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException e) {}
            try {
                bin.close();
            }
            catch (IOException e) {}
        }
    }

    private static String getPropertyFile(String sampleName, String sampleDir) {
        String samplePath = sampleDir + File.separator + "resources" + File.separator + "bpel" + File.separator + sampleName + ".properties";
        File sample = new File(samplePath);
        if (sample.exists()) {
            return samplePath;
        }
        samplePath = sampleDir + File.separator + "resources" + File.separator + "humantask" + File.separator + sampleName + ".properties";
        sample = new File(samplePath);
        if (sample.exists()) {
            return samplePath;
        }
        return null;
    }

    private static void printResult(OMElement element) throws Exception {
        System.out.println("Received response from the service");
        System.out.println(element.toStringWithConsume());
        System.exit(0);
    }

    public static void executeClient() throws Exception {
        ServiceClient serviceClient;
        String propertyFile;
        String soapVer = SamplesInvoker.getProperty("soapver", "soap11");
        String addUrl = SamplesInvoker.getProperty("addurl", null);
        String trpUrl = SamplesInvoker.getProperty("trpurl", null);
        String prxUrl = SamplesInvoker.getProperty("prxurl", null);
        String repository = SamplesInvoker.getProperty("repository", "client_repo");
        String sampleName = SamplesInvoker.getProperty("sample", "CreditRating");
        String sampleDir = SamplesInvoker.getProperty("sampleDir", ".");
        String operation = SamplesInvoker.getProperty("operation", null);
        String createUsers = SamplesInvoker.getProperty("createUsers", "false");
        if ("true".equals(createUsers)) {
            SamplesInvoker.createUsers();
        }
        if ((propertyFile = SamplesInvoker.getPropertyFile(sampleName, sampleDir)) != null) {
            SamplesInvoker.loadServiceProperties(propertyFile, operation);
        } else {
            System.out.println("Matching properties file not found for the specified sample");
            System.exit(0);
        }
        ConfigurationContext configContext = null;
        if (repository != null && !"null".equals(repository)) {
            configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository, (String)(repository + File.separator + "conf" + File.separator + "axis2.xml"));
            serviceClient = new ServiceClient(configContext, null);
        } else {
            serviceClient = new ServiceClient();
        }
        Options options = new Options();
        if (action != null && !action.equals("")) {
            options.setAction(action);
        } else {
            serviceClient.disengageModule("addressing");
            options.setProperty("disableAddressingForOutMessages", (Object)true);
        }
        if (addUrl != null && !"null".equals(addUrl + serviceName)) {
            options.setTo(new EndpointReference(addUrl));
        }
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)(trpUrl + serviceName));
        }
        if (prxUrl != null && !"null".equals(prxUrl)) {
            HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
            URL url = new URL(prxUrl);
            proxyProperties.setProxyName(url.getHost());
            proxyProperties.setProxyPort(url.getPort());
            proxyProperties.setUserName("");
            proxyProperties.setPassWord("");
            proxyProperties.setDomain("");
            options.setProperty("PROXY", (Object)proxyProperties);
        }
        if ("soap12".equals(soapVer)) {
            options.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
        }
        serviceClient.setOptions(options);
        OMElement response = serviceClient.sendReceive(requestPayload);
        SamplesInvoker.printResult(response);
    }

    private static void createUsers() {
        try {
            SamplesInvoker.initUserAdminStub();
            SamplesInvoker.addRoles();
            SamplesInvoker.addUsers();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initUserAdminStub() throws Exception {
        userAdminStub = new UserAdminStub(USER_MANAGEMENT_SERVICE_URL);
        ServiceClient serviceClient = userAdminStub._getServiceClient();
        Options serviceClientOptions = serviceClient.getOptions();
        serviceClientOptions.setManageSession(true);
        CarbonUtils.setBasicAccessSecurityHeaders((String)"admin", (String)"admin", (ServiceClient)serviceClient);
    }

    private static void iniAuthenticationAdminStub() throws Exception {
        authenticationAdminStub = new AuthenticationAdminStub(AUTHENTICATION_SERVICE_URL);
        ServiceClient client = authenticationAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
    }

    private static void addRoles() throws Exception {
        userAdminStub.addRole("regionalClerksRole", null, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
        userAdminStub.addRole("regionalManagerRole", null, new String[]{"/permission/admin/login", "/permission/admin/manage/humantask/viewtasks"}, false);
    }

    private static void addUsers() throws Exception {
        userAdminStub.addUser("clerk1", "clerk1password", new String[]{"regionalClerksRole"}, null, null);
        userAdminStub.addUser("clerk2", "clerk2password", new String[]{"regionalClerksRole"}, null, null);
        userAdminStub.addUser("manager", "managerpassword", new String[]{"regionalManagerRole"}, null, null);
    }
}

