/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.jmeter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.util.ShutdownClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.jmeter.JMeterInstallationProvider;
import org.wso2.carbon.automation.extensions.jmeter.JMeterResult;
import org.wso2.carbon.automation.extensions.jmeter.JMeterTest;
import org.xml.sax.SAXException;

public class JMeterTestManager {
    private static final Pattern PAT_ERROR = Pattern.compile(".*\\s+ERROR\\s+.*");
    private static final Log log = LogFactory.getLog(JMeterTestManager.class);
    private String jmeterLogLevel = "INFO";
    private File testFile = null;
    private File jmeterHome = null;
    private File jmeterLogFile = null;
    private DateFormat fmt = new SimpleDateFormat("yyMMdd-HH-mm-ss");
    private File jmeterProps = null;

    public void runTest(JMeterTest jMeterTest) throws AutomationFrameworkException {
        this.jmeterHome = JMeterInstallationProvider.getInstance().getJMeterHome();
        this.testFile = jMeterTest.getTestFile();
        try {
            this.setJMeterPropertyFile(jMeterTest);
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Set property failed " + e.getMessage(), (Throwable)e);
        }
        if (jMeterTest.getLogLevel() != null) {
            this.jmeterLogLevel = jMeterTest.getLogLevel();
        }
        JMeterResult results = this.executeMe();
        log.info((Object)("for more info. " + results.getFileName()));
        if (results.getErrorCount() > 0L) {
            throw new AutomationFrameworkException("Test Failed. " + results.getErrorCount() + " Error/s Found.\n" + results.getErrorList().toString() + "\nRefer " + results.getFileName() + " for test result");
        }
        if (results.getFailureCount() > 0L) {
            throw new AssertionError((Object)("Test Failed. " + results.getFailureCount() + " Assertion Failure/s.\n" + results.getAssertList().toString() + "\nRefer " + results.getFileName() + " for test result"));
        }
    }

    private JMeterResult executeMe() throws AutomationFrameworkException {
        try {
            this.addLogFile(this.testFile.getName());
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Can't add log file " + e.getMessage(), (Throwable)e);
        }
        Boolean resultState = true;
        String resultFile = this.executeTest(this.testFile);
        try {
            StandardJMeterEngine.stopEngineNow();
            ShutdownClient.main((String[])new String[]{"Shutdown"});
        }
        catch (IOException ex) {
            log.error((Object)ex);
            resultState = false;
        }
        JMeterResult results = this.resultValidator(resultFile);
        results.setFileName(resultFile);
        results.setExecutionState(resultState);
        return results;
    }

    private void checkForErrors() throws AutomationFrameworkException, IOException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.jmeterLogFile), Charset.defaultCharset()));
            while ((line = in.readLine()) != null) {
                if (!PAT_ERROR.matcher(line).find()) continue;
                throw new AutomationFrameworkException("There were test errors, see logfile '" + this.jmeterLogFile + "' for further information");
            }
            in.close();
        }
        catch (IOException e) {
            throw new IOException("Can't read log file", e);
        }
    }

    private void setJMeterPropertyFile(JMeterTest jMeterTest) throws IOException {
        if (jMeterTest.getJMeterPropertyFile() == null) {
            log.info((Object)"Loading default jmeter.properties...");
            this.jmeterProps = JMeterInstallationProvider.getInstance().getJMeterPropertyFile();
            System.setProperty("jmeter_properties", File.separator + "bin" + File.separator + "jmeter.properties");
        } else {
            log.info((Object)("Loading custom jmeter.properties from " + jMeterTest.getJMeterPropertyFile().getCanonicalPath()));
            this.jmeterProps = jMeterTest.getJMeterPropertyFile();
            System.setProperty("jmeter_properties", this.jmeterProps.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeTest(File test) throws AutomationFrameworkException {
        String reportFileFullPath;
        JMeter jmeterInstance = new JMeter();
        try {
            log.info((Object)("Executing test: " + test.getCanonicalPath()));
            String reportFileName = test.getName().substring(0, test.getName().lastIndexOf(".")) + "-" + this.fmt.format(new Date()) + ".jmeterResult.jtl";
            File reportDir = JMeterInstallationProvider.getInstance().getReportDir();
            reportFileFullPath = reportDir.toString() + File.separator + reportFileName;
            List<String> argsTmp = Arrays.asList("-n", "-t", test.getCanonicalPath(), "-l", reportDir.toString() + File.separator + reportFileName, "-p", this.jmeterProps.toString(), "-d", this.jmeterHome.getCanonicalPath(), "-L", "jorphan=" + this.jmeterLogLevel, "-L", "jmeter.util=" + this.jmeterLogLevel);
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(argsTmp);
            SecurityManager oldManager = System.getSecurityManager();
            Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (e instanceof ExitException && ((ExitException)e).getCode() == 0) {
                        return;
                    }
                    log.error((Object)("Error in thread " + t.getName()));
                }
            });
            try {
                this.logParamsAndProps(args);
                jmeterInstance.start(args.toArray(new String[0]));
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.jmeterLogFile), Charset.defaultCharset()));
                while (!this.checkForEndOfTest(in)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            catch (ExitException e) {
                if (e.getCode() != 0) {
                    throw new AutomationFrameworkException("Test failed " + e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                System.setSecurityManager(oldManager);
                Thread.setDefaultUncaughtExceptionHandler(oldHandler);
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Can't execute test " + e.getMessage(), (Throwable)e);
        }
        return reportFileFullPath;
    }

    private void logParamsAndProps(List<String> args) {
        log.debug((Object)"Starting JMeter with the following parameters:");
        for (String arg : args) {
            log.debug((Object)arg);
        }
        Properties props = System.getProperties();
        Set<Object> keysUnsorted = props.keySet();
        TreeSet<Object> keys = new TreeSet<Object>(keysUnsorted);
        log.debug((Object)"... and the following properties:");
        for (Object e : keys) {
            String key = (String)e;
            String value = props.getProperty(key);
            log.debug((Object)(key + " = " + value));
        }
    }

    private JMeterResult resultValidator(String fileName) throws AutomationFrameworkException {
        JMeterResult result = null;
        XMLStreamReader parser = null;
        FileInputStream inputStream = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
                parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(file);
                doc.getDocumentElement().normalize();
                ArrayList<String> errorList = new ArrayList<String>();
                result = new JMeterResult();
                ArrayList<String> assertionFailureList = new ArrayList<String>();
                NodeList nodeList = doc.getElementsByTagName("httpSample");
                for (int temp = 0; temp < nodeList.getLength(); ++temp) {
                    String name = null;
                    String error = null;
                    String failure = null;
                    String failureMessage = null;
                    Node node = nodeList.item(temp);
                    String responseMessage = node.getAttributes().getNamedItem("s").getTextContent();
                    String label = node.getAttributes().getNamedItem("lb").getTextContent();
                    if ("false".equalsIgnoreCase(responseMessage)) {
                        result.increaseErrorCount();
                        String errorMessage = label + " > " + responseMessage;
                        if (!errorList.contains(errorMessage)) {
                            errorList.add(errorMessage);
                        }
                    }
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    if (element.getElementsByTagName("name").getLength() != 0) {
                        name = element.getElementsByTagName("name").item(0).getTextContent();
                    }
                    if (element.getElementsByTagName("error").getLength() != 0) {
                        error = element.getElementsByTagName("error").item(0).getTextContent();
                    }
                    if (element.getElementsByTagName("failure").getLength() != 0) {
                        failure = element.getElementsByTagName("failure").item(0).getTextContent();
                    }
                    if (element.getElementsByTagName("failureMessage").getLength() != 0) {
                        failureMessage = element.getElementsByTagName("failureMessage").item(0).getTextContent();
                    }
                    if (!"true".equalsIgnoreCase(failure) && !"true".equalsIgnoreCase(error)) continue;
                    result.increaseFailureCount();
                    String assertionFailure = label + " : " + name + " > " + failureMessage;
                    if (assertionFailureList.contains(assertionFailure)) continue;
                    assertionFailureList.add(assertionFailure);
                }
                result.setErrorList(errorList);
                result.setAssertList(assertionFailureList);
            }
            catch (FileNotFoundException e) {
                throw new AutomationFrameworkException("Result File is not Created");
            }
            catch (ParserConfigurationException e) {
                throw new AutomationFrameworkException("Result File is not Created");
            }
            catch (SAXException e) {
                throw new AutomationFrameworkException("Result File is not Created");
            }
            catch (IOException e) {
                throw new AutomationFrameworkException("Result File is not Created");
            }
            catch (XMLStreamException e) {
                throw new AutomationFrameworkException("Result File is not Created");
            }
            finally {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new AutomationFrameworkException("Result File is not Created");
        return result;
    }

    private boolean checkForEndOfTest(BufferedReader in) throws IOException {
        boolean testEnded = false;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (!line.contains("Test has ended")) continue;
                testEnded = true;
                break;
            }
        }
        catch (IOException e) {
            throw new IOException("Can't read log file", e);
        }
        return testEnded;
    }

    private void addLogFile(String fileName) throws IOException {
        this.jmeterLogFile = new File(JMeterInstallationProvider.getInstance().getLogDir().getCanonicalPath() + File.separator + fileName.substring(0, fileName.lastIndexOf(".")) + "-" + this.fmt.format(new Date()) + ".log");
        if (!this.jmeterLogFile.createNewFile()) {
            log.error((Object)"unable to create log file");
        }
        try {
            System.setProperty("log_file", this.jmeterLogFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IOException("Can't get canonical path for log file " + e.getMessage(), e);
        }
    }

    private static class ExitException
    extends SecurityException {
        private static final long serialVersionUID = 5544099211927987521L;
        public int _rc;

        public ExitException(int rc) {
            super(Integer.toString(rc));
            this._rc = rc;
        }

        public int getCode() {
            return this._rc;
        }
    }
}

