/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.carbonserver;

import java.io.File;
import java.io.IOException;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.extensions.FrameworkExtensionUtils;
import org.wso2.carbon.automation.extensions.servers.utils.FileManipulator;

public class CarbonPackageManager {
    private static final Log log = LogFactory.getLog(CarbonPackageManager.class);

    public String unzipCarbonPackage() throws ZipException {
        String carbonHome;
        String carbonTempHome = FrameworkExtensionUtils.getCarbonTempLocation();
        String carbonZipFileLocation = FrameworkExtensionUtils.getCarbonZipLocation();
        if (new File(carbonTempHome).exists()) {
            FileManipulator.deleteDir(new File(carbonTempHome));
        }
        try {
            ZipFile zipFile = new ZipFile(FrameworkExtensionUtils.getCarbonZipLocation());
            carbonHome = carbonTempHome + File.separator + carbonZipFileLocation.substring(carbonZipFileLocation.lastIndexOf(File.separator) + 1, carbonZipFileLocation.indexOf(".zip"));
            log.info((Object)("Extracting carbon distribution into : " + carbonTempHome));
            zipFile.extractAll(carbonTempHome);
        }
        catch (ZipException e) {
            log.error((Object)("Unable to extract distribution at " + FrameworkExtensionUtils.getCarbonZipLocation()));
            throw new ZipException("Unable to extract distribution at " + FrameworkExtensionUtils.getCarbonZipLocation(), (Throwable)e);
        }
        return carbonHome;
    }

    public void copySecurityVerificationService() throws IOException {
        String secVerifierDir = System.getProperty("sec.verifier.dir");
        File srcFile = new File(secVerifierDir + "SecVerifier.aar");
        String deploymentPath = FrameworkExtensionUtils.getCarbonServerAxisServiceDirectory();
        File depFile = new File(deploymentPath);
        if (!depFile.exists() && !depFile.mkdir()) {
            throw new IOException("Error while creating the deployment folder : " + deploymentPath);
        }
        File dstFile = new File(depFile.getAbsolutePath() + File.separator + "SecVerifier.aar");
        log.info((Object)("Copying " + srcFile.getAbsolutePath() + " => " + dstFile.getAbsolutePath()));
        FileManipulator.copyFile(srcFile, dstFile);
    }
}

