/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.carbonserver;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.CodeCoverageUtils;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.engine.frameworkutils.ReportGenerator;
import org.wso2.carbon.automation.engine.frameworkutils.TestFrameworkUtils;
import org.wso2.carbon.automation.extensions.servers.utils.ArchiveExtractor;
import org.wso2.carbon.automation.extensions.servers.utils.ClientConnectionUtil;
import org.wso2.carbon.automation.extensions.servers.utils.FileManipulator;
import org.wso2.carbon.automation.extensions.servers.utils.ServerLogReader;

public class CarbonServerManager {
    private static final Log log = LogFactory.getLog(CarbonServerManager.class);
    private Process process;
    private String carbonHome;
    private AutomationContext automationContext;
    private ServerLogReader inputStreamHandler;
    private ServerLogReader errorStreamHandler;
    private boolean isCoverageEnable = false;
    private Set<String> coverageClassesDirectories = new HashSet<String>();
    private String coverageDumpFilePath;
    private int portOffset = 0;
    private static final String SERVER_SHUTDOWN_MESSAGE = "Halting JVM";
    private static final String SERVER_STARTUP_MESSAGE = "Mgt Console URL";
    private static final long DEFAULT_START_STOP_WAIT_MS = 300000L;
    private static final String CMD_ARG = "cmdArg";
    private static int defaultHttpPort = Integer.parseInt("9763");
    private static int defaultHttpsPort = Integer.parseInt("9443");

    public CarbonServerManager(AutomationContext context) {
        this.automationContext = context;
    }

    public synchronized void startServerUsingCarbonHome(String carbonHome, Map<String, String> commandMap) throws AutomationFrameworkException {
        if (this.process != null) {
            return;
        }
        this.portOffset = this.checkPortAvailability(commandMap);
        Process tempProcess = null;
        try {
            String[] cmdArray;
            if (!commandMap.isEmpty() && this.getPortOffsetFromCommandMap(commandMap) == 0) {
                System.setProperty("carbon.home", carbonHome);
            }
            File commandDir = new File(carbonHome);
            log.info((Object)"Starting carbon server............. ");
            String scriptName = TestFrameworkUtils.getStartupScriptFileName((String)carbonHome);
            String[] parameters = this.expandServerStartupCommandList(commandMap);
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                commandDir = new File(carbonHome + File.separator + "bin");
                cmdArray = new String[]{"cmd.exe", "/c", scriptName + ".bat"};
                cmdArray = this.mergePropertiesToCommandArray(parameters, cmdArray);
                tempProcess = Runtime.getRuntime().exec(cmdArray, null, commandDir);
            } else {
                cmdArray = new String[]{"sh", "bin/" + scriptName + ".sh"};
                cmdArray = this.mergePropertiesToCommandArray(parameters, cmdArray);
                tempProcess = Runtime.getRuntime().exec(cmdArray, null, commandDir);
            }
            this.errorStreamHandler = new ServerLogReader("errorStream", tempProcess.getErrorStream());
            this.inputStreamHandler = new ServerLogReader("inputStream", tempProcess.getInputStream());
            this.inputStreamHandler.start();
            this.errorStreamHandler.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        CarbonServerManager.this.serverShutdown(CarbonServerManager.this.portOffset);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while server shutdown ..", (Throwable)e);
                    }
                }
            });
            ClientConnectionUtil.waitForPort(defaultHttpPort + this.portOffset, 300000L, false, (String)this.automationContext.getInstance().getHosts().get("default"));
            long time = System.currentTimeMillis() + 60000L;
            while (!this.inputStreamHandler.getOutput().contains(SERVER_STARTUP_MESSAGE) && System.currentTimeMillis() < time) {
            }
            int httpsPort = defaultHttpsPort + this.portOffset;
            String backendURL = this.automationContext.getContextUrls().getSecureServiceUrl().replaceAll("(:\\d+)", ":" + httpsPort);
            User superUser = this.automationContext.getSuperTenant().getTenantAdmin();
            ClientConnectionUtil.waitForLogin(backendURL, superUser);
            log.info((Object)"Server started successfully.");
        }
        catch (IOException | XPathExpressionException e) {
            throw new IllegalStateException("Unable to start server", e);
        }
        this.process = tempProcess;
    }

    private int checkPortAvailability(Map<String, String> commandMap) throws AutomationFrameworkException {
        int portOffset = this.getPortOffsetFromCommandMap(commandMap);
        if (ClientConnectionUtil.isPortOpen(defaultHttpPort + portOffset)) {
            throw new AutomationFrameworkException("Unable to start carbon server on port " + (defaultHttpPort + portOffset) + " : Port already in use");
        }
        if (ClientConnectionUtil.isPortOpen(defaultHttpsPort + portOffset)) {
            throw new AutomationFrameworkException("Unable to start carbon server on port " + (defaultHttpsPort + portOffset) + " : Port already in use");
        }
        return portOffset;
    }

    private String[] mergePropertiesToCommandArray(String[] parameters, String[] cmdArray) {
        if (parameters != null) {
            cmdArray = this.mergerArrays(cmdArray, parameters);
        }
        return cmdArray;
    }

    public synchronized String setUpCarbonHome(String carbonServerZipFile) throws IOException, AutomationFrameworkException {
        String fileSeparator;
        if (this.process != null) {
            return this.carbonHome;
        }
        int indexOfZip = carbonServerZipFile.lastIndexOf(".zip");
        if (indexOfZip == -1) {
            throw new IllegalArgumentException(carbonServerZipFile + " is not a zip file");
        }
        String string = fileSeparator = File.separator.equals("\\") ? "\\" : "/";
        if (fileSeparator.equals("\\")) {
            carbonServerZipFile = carbonServerZipFile.replace("/", "\\");
        }
        String extractedCarbonDir = carbonServerZipFile.substring(carbonServerZipFile.lastIndexOf(fileSeparator) + 1, indexOfZip);
        FileManipulator.deleteDir(extractedCarbonDir);
        String extractDir = "carbontmp" + System.currentTimeMillis();
        String baseDir = System.getProperty("basedir", ".") + File.separator + "target";
        log.info((Object)"Extracting carbon zip file.. ");
        new ArchiveExtractor().extractFile(carbonServerZipFile, baseDir + File.separator + extractDir);
        this.carbonHome = new File(baseDir).getAbsolutePath() + File.separator + extractDir + File.separator + extractedCarbonDir;
        try {
            this.isCoverageEnable = Boolean.parseBoolean(this.automationContext.getConfigurationValue("//coverage"));
            this.coverageClassesDirectories = this.getCoverageClassesDirectories(this.automationContext);
        }
        catch (XPathExpressionException e) {
            throw new AutomationFrameworkException("Coverage configuration not found in automation.xml", (Throwable)e);
        }
        if (this.isCoverageEnable) {
            this.instrumentForCoverage();
        }
        return this.carbonHome;
    }

    public synchronized void serverShutdown(int portOffset) throws AutomationFrameworkException {
        if (this.process != null) {
            log.info((Object)"Shutting down server..");
            if (ClientConnectionUtil.isPortOpen(Integer.parseInt("9443") + portOffset)) {
                int httpsPort = defaultHttpsPort + portOffset;
                String url = null;
                try {
                    url = this.automationContext.getContextUrls().getBackEndUrl();
                }
                catch (XPathExpressionException e) {
                    throw new AutomationFrameworkException("Get context failed", (Throwable)e);
                }
                String backendURL = url.replaceAll("(:\\d+)", ":" + httpsPort);
                try {
                    ClientConnectionUtil.sendForcefulShutDownRequest(backendURL, this.automationContext.getSuperTenant().getContextUser().getUserName(), this.automationContext.getSuperTenant().getContextUser().getPassword());
                }
                catch (AutomationFrameworkException e) {
                    throw new AutomationFrameworkException("Get context failed", (Throwable)e);
                }
                catch (XPathExpressionException e) {
                    throw new AutomationFrameworkException("Get context failed", (Throwable)e);
                }
                long time = System.currentTimeMillis() + 300000L;
                while (!this.inputStreamHandler.getOutput().contains(SERVER_SHUTDOWN_MESSAGE) && System.currentTimeMillis() < time) {
                }
                log.info((Object)"Server stopped successfully...");
            }
            this.inputStreamHandler.stop();
            this.errorStreamHandler.stop();
            this.process.destroy();
            this.process = null;
            if (this.isCoverageEnable) {
                try {
                    log.info((Object)"Generating Jacoco code coverage...");
                    this.generateCoverageReport(this.coverageClassesDirectories);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to generate code coverage ", (Throwable)e);
                    throw new AutomationFrameworkException("Failed to generate code coverage ", (Throwable)e);
                }
            }
            if (portOffset == 0) {
                System.clearProperty("carbon.home");
            }
        }
    }

    private void generateCoverageReport(Set<String> classesDir) throws IOException, AutomationFrameworkException {
        CodeCoverageUtils.executeMerge((String)FrameworkPathUtil.getJacocoCoverageHome(), (String)FrameworkPathUtil.getCoverageMergeFilePath());
        ReportGenerator reportGenerator = new ReportGenerator(new File(FrameworkPathUtil.getCoverageMergeFilePath()), classesDir, new File(CodeCoverageUtils.getJacocoReportDirectory()), null);
        reportGenerator.create();
        log.info((Object)("Jacoco coverage dump file path : " + FrameworkPathUtil.getCoverageDumpFilePath()));
        log.info((Object)"Jacoco class file paths analyzed");
        for (String classDirectory : classesDir) {
            log.info((Object)("-- " + classDirectory));
        }
        log.info((Object)("Jacoco coverage HTML report path : " + CodeCoverageUtils.getJacocoReportDirectory() + File.separator + "index.html"));
    }

    public synchronized void restartGracefully() throws AutomationFrameworkException {
        try {
            int httpsPort = defaultHttpsPort + this.portOffset;
            String backendURL = this.automationContext.getContextUrls().getSecureServiceUrl().replaceAll("(:\\d+)", ":" + httpsPort);
            User superUser = this.automationContext.getSuperTenant().getTenantAdmin();
            ClientConnectionUtil.sendGraceFullRestartRequest(backendURL, superUser.getUserName(), superUser.getPassword());
        }
        catch (XPathExpressionException e) {
            throw new AutomationFrameworkException("restart failed", (Throwable)e);
        }
        long time = System.currentTimeMillis() + 300000L;
        while (!this.inputStreamHandler.getOutput().contains(SERVER_SHUTDOWN_MESSAGE) && System.currentTimeMillis() < time) {
        }
        time = System.currentTimeMillis();
        while (System.currentTimeMillis() < time + 5000L) {
        }
        try {
            ClientConnectionUtil.waitForPort(Integer.parseInt((String)this.automationContext.getInstance().getPorts().get("https")), (String)this.automationContext.getInstance().getHosts().get("default"));
            ClientConnectionUtil.waitForLogin(this.automationContext);
        }
        catch (XPathExpressionException e) {
            throw new AutomationFrameworkException("Connection attempt to carbon server failed", (Throwable)e);
        }
    }

    private String[] expandServerStartupCommandList(Map<String, String> commandMap) {
        if (commandMap == null || commandMap.size() == 0) {
            return null;
        }
        Object[] cmdParaArray = null;
        String cmdArg = null;
        if (commandMap.containsKey(CMD_ARG)) {
            cmdArg = commandMap.get(CMD_ARG);
            cmdParaArray = cmdArg.trim().split("\\s+");
            commandMap.remove(CMD_ARG);
        }
        Object[] parameterArray = new String[commandMap.size()];
        int arrayIndex = 0;
        Set<Map.Entry<String, String>> entries = commandMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            String parameter = value == null || value.isEmpty() ? key : key + "=" + value;
            parameterArray[arrayIndex++] = parameter;
        }
        if (cmdArg != null) {
            commandMap.put(CMD_ARG, cmdArg);
        }
        if (cmdParaArray == null || cmdParaArray.length == 0) {
            return parameterArray;
        }
        return (String[])ArrayUtils.addAll((Object[])parameterArray, (Object[])cmdParaArray);
    }

    private int getPortOffsetFromCommandMap(Map<String, String> commandMap) {
        if (commandMap.containsKey("-DportOffset")) {
            return Integer.parseInt(commandMap.get("-DportOffset"));
        }
        return 0;
    }

    private String[] mergerArrays(String[] array1, String[] array2) {
        return (String[])ArrayUtils.addAll((Object[])array1, (Object[])array2);
    }

    private void insertJacocoAgentToShellScript(String scriptName) throws IOException {
        String jacocoAgentFile = CodeCoverageUtils.getJacocoAgentJarLocation();
        this.coverageDumpFilePath = FrameworkPathUtil.getCoverageDumpFilePath();
        CodeCoverageUtils.insertStringToFile((File)new File(this.carbonHome + File.separator + "bin" + File.separator + scriptName + ".sh"), (File)new File(this.carbonHome + File.separator + "tmp" + File.separator + scriptName + ".sh"), (String)"-Dwso2.server.standalone=true", (String)("-javaagent:" + jacocoAgentFile + "=destfile=" + this.coverageDumpFilePath + ",append=true,includes=" + CodeCoverageUtils.getInclusionJarsPattern((String)":") + " \\"));
    }

    private void insertJacocoAgentToBatScript(String scriptName) throws IOException {
        String jacocoAgentFile = CodeCoverageUtils.getJacocoAgentJarLocation();
        this.coverageDumpFilePath = FrameworkPathUtil.getCoverageDumpFilePath();
        CodeCoverageUtils.insertJacocoAgentToStartupBat((File)new File(this.carbonHome + File.separator + "bin" + File.separator + scriptName + ".bat"), (File)new File(this.carbonHome + File.separator + "tmp" + File.separator + scriptName + ".bat"), (String)"-Dcatalina.base", (String)("-javaagent:" + jacocoAgentFile + "=destfile=" + this.coverageDumpFilePath + ",append=true,includes=" + CodeCoverageUtils.getInclusionJarsPattern((String)":")));
    }

    private void instrumentForCoverage() throws IOException, AutomationFrameworkException {
        String scriptName = TestFrameworkUtils.getStartupScriptFileName((String)this.carbonHome);
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.insertJacocoAgentToBatScript(scriptName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Included files " + CodeCoverageUtils.getInclusionJarsPattern((String)":")));
                log.debug((Object)("Excluded files " + CodeCoverageUtils.getExclusionJarsPattern((String)":")));
            }
        } else {
            this.insertJacocoAgentToShellScript(scriptName);
        }
    }

    private Set<String> getCoverageClassesDirectories(AutomationContext automationContext) throws XPathExpressionException {
        HashSet<String> coverageDirectories = new HashSet<String>();
        Node configurationNode = automationContext.getConfigurationNode("//coverageClassesRelativeDirectories");
        if (configurationNode != null) {
            NodeList childNodes = configurationNode.getChildNodes();
            if (childNodes != null) {
                for (int i = 0; i <= childNodes.getLength() - 1; ++i) {
                    Node node = childNodes.item(i);
                    if (node == null || !"coverageClassesRelativeDirectory".equals(node.getNodeName())) continue;
                    coverageDirectories.add(node.getTextContent());
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)automationContext.getConfigurationValue("//coverageClassesRelativeDirectory"))) {
            coverageDirectories.add(automationContext.getConfigurationValue("//coverageClassesRelativeDirectory"));
        } else {
            coverageDirectories.add("repository" + File.separator + "components" + File.separator + "plugins" + File.separator);
        }
        return coverageDirectories;
    }
}

