/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.jmsserver.client;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;

public class JMSQueueMessageConsumer {
    private Connection connection = null;
    private Session session = null;
    private QueueConnectionFactory connectionFactory = null;
    private Destination destination = null;
    private MessageConsumer consumer = null;

    public JMSQueueMessageConsumer(JMSBrokerConfiguration brokerConfiguration) throws NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", brokerConfiguration.getInitialNamingFactory());
        if (brokerConfiguration.getProviderURL().startsWith("amqp://")) {
            props.put("connectionfactory.QueueConnectionFactory", brokerConfiguration.getProviderURL());
        } else {
            props.setProperty("java.naming.provider.url", brokerConfiguration.getProviderURL());
        }
        InitialContext ctx = new InitialContext(props);
        this.connectionFactory = (QueueConnectionFactory)ctx.lookup("QueueConnectionFactory");
    }

    public void connect(String queueName) throws JMSException, NamingException {
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.session.createQueue(queueName);
        this.consumer = this.session.createConsumer(this.destination);
    }

    public void disconnect() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public String popMessage() throws AutomationFrameworkException {
        if (this.consumer == null) {
            throw new AutomationFrameworkException("No Consumer with Queue. Please connect");
        }
        Message message = null;
        try {
            message = this.consumer.receive(10000L);
            if (message != null) {
                if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    return textMessage.getText();
                }
                throw new AutomationFrameworkException("Test Framework Exception. Message Type is not a TextMessage");
            }
            return null;
        }
        catch (JMSException e) {
            throw new AutomationFrameworkException("Test Framework Exception. Message Type is not a TextMessage", (Throwable)e);
        }
    }

    public <T> T popMessage(Class<T> clzz) throws AutomationFrameworkException {
        if (this.consumer == null) {
            throw new AutomationFrameworkException("No Consumer with Queue. Please connect");
        }
        Message message = null;
        try {
            message = this.consumer.receive(10000L);
            if (message != null) {
                if (clzz.isInstance(message)) {
                    return clzz.cast(message);
                }
                throw new AutomationFrameworkException("Test Framework Exception. Unexpected Message Type to cast");
            }
            return null;
        }
        catch (JMSException e) {
            throw new AutomationFrameworkException("Test Framework Exception. Unexpected Message Type to cast", (Throwable)e);
        }
    }

    public Message popRawMessage() throws AutomationFrameworkException {
        if (this.consumer == null) {
            throw new AutomationFrameworkException("No Consumer with Queue. Please connect");
        }
        try {
            return this.consumer.receive(10000L);
        }
        catch (JMSException e) {
            throw new AutomationFrameworkException("message receiving failed", (Throwable)e);
        }
    }

    public List<String> getMessages() throws AutomationFrameworkException {
        if (this.session == null) {
            throw new AutomationFrameworkException("No Connection with Queue. Please connect");
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            QueueBrowser browser = this.session.createBrowser((Queue)this.destination);
            Enumeration enu = browser.getEnumeration();
            while (enu.hasMoreElements()) {
                TextMessage message = (TextMessage)enu.nextElement();
                list.add(message.getText());
            }
            browser.close();
        }
        catch (JMSException e) {
            throw new AutomationFrameworkException("create browser failed ", (Throwable)e);
        }
        return list;
    }
}

