/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.broker.TransportConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;

public class JMSBrokerConfigurationProvider {
    private static final Log log = LogFactory.getLog(JMSBrokerConfigurationProvider.class);
    private static JMSBrokerConfigurationProvider instance = new JMSBrokerConfigurationProvider();
    private List<TransportConnector> connectors = new ArrayList<TransportConnector>();
    private JMSBrokerConfiguration tcp = new JMSBrokerConfiguration();
    private JMSBrokerConfiguration mqtt = new JMSBrokerConfiguration();

    private JMSBrokerConfigurationProvider() {
        this.setTransportConnectors();
        this.setBrokerConfig();
    }

    public static JMSBrokerConfigurationProvider getInstance() {
        return instance;
    }

    public JMSBrokerConfiguration getBrokerConfiguration() {
        return this.getJMSBrokerConfiguration("tcp");
    }

    public JMSBrokerConfiguration getBrokerConfiguration(String transport) {
        return this.getJMSBrokerConfiguration(transport);
    }

    public List<TransportConnector> getTransportConnectors() {
        return this.connectors;
    }

    private TransportConnector getTCPConnector() {
        TransportConnector tcp = new TransportConnector();
        tcp.setName("tcp");
        try {
            tcp.setUri(new URI("tcp://127.0.0.1:61616"));
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error while setting tcp uri :tcp://127.0.0.1:61616", (Throwable)e);
        }
        return tcp;
    }

    private TransportConnector getMQTTConnector() {
        TransportConnector mqtt = new TransportConnector();
        mqtt.setName("mqtt");
        try {
            mqtt.setUri(new URI("mqtt://localhost:1883"));
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error while setting MQTT uri:mqtt://localhost:1883");
        }
        return mqtt;
    }

    private void setTransportConnectors() {
        this.connectors.add(this.getTCPConnector());
        this.connectors.add(this.getMQTTConnector());
    }

    private JMSBrokerConfiguration getJMSBrokerConfiguration(String transportName) {
        if ("tcp".equalsIgnoreCase(transportName)) {
            return this.tcp;
        }
        if ("mqtt".equalsIgnoreCase(transportName)) {
            return this.mqtt;
        }
        JMSBrokerConfiguration jmsBrokerConfiguration = new JMSBrokerConfiguration();
        jmsBrokerConfiguration.setInitialNamingFactory("org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        for (TransportConnector con : this.getTransportConnectors()) {
            if (!transportName.equalsIgnoreCase(con.getName())) continue;
            jmsBrokerConfiguration.setProviderURL(con.getUri().toString());
        }
        return jmsBrokerConfiguration;
    }

    private void setBrokerConfig() {
        this.tcp.setInitialNamingFactory("org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        this.tcp.setProviderURL(this.getTCPConnector().getUri().toString());
        this.mqtt.setInitialNamingFactory("org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        this.mqtt.setProviderURL(this.getMQTTConnector().getUri().toString());
    }
}

