/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.proxyserver;

import java.net.ServerSocket;
import java.net.Socket;
import org.wso2.carbon.automation.extensions.servers.proxyserver.ProxyConnection;

public class Proxy {
    static int clientCount;

    public static synchronized void print(int i) {
        System.out.print((char)i);
    }

    public static synchronized void println(String s) {
        System.out.println(s);
    }

    public static synchronized void display(String s) {
        System.err.println(s);
    }

    public static synchronized void quit(long t) {
        Proxy.display("...quit after waiting " + t + " ms");
        --clientCount;
    }

    public void run(int localport, String host, int port, long timeout) {
        try {
            ServerSocket sSocket = new ServerSocket(localport);
            while (true) {
                Socket cSocket = null;
                try {
                    Proxy.display("listening...");
                    cSocket = sSocket.accept();
                    if (cSocket != null) {
                        Proxy.incrementCount();
                        Proxy.display("accepted as #" + clientCount + ":" + cSocket);
                        ProxyConnection c = new ProxyConnection(cSocket, host, port, timeout);
                        c.start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                try {
                    cSocket.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return;
        }
    }

    private static void incrementCount() {
        ++clientCount;
    }

    private static void decrementCount() {
        --clientCount;
    }
}

