/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.sftpserver;

import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;

public class SFTPServer
extends Thread {
    private Log log = LogFactory.getLog(SFTPServer.class);
    private static final String USERNAME = "SFTPUser";
    private static final char[] PASSWORD = new char[]{'S', 'F', 'T', 'P', '3', '2', '1'};
    private static SshServer sshServer = SshServer.setUpDefaultServer();
    private static int port = 8005;
    private static boolean isKeepAlive = false;
    public static final String DEFAULT_TEST_HOST_KEY_PROVIDER_ALGORITHM = "RSA";

    public boolean isKeepAlive() {
        return isKeepAlive;
    }

    public static void setKeepAlive(boolean keepAlive) {
        isKeepAlive = keepAlive;
    }

    public void startServer() {
        Thread thread = new Thread(new SFTPServer());
        thread.start();
    }

    @Override
    public void run() {
        sshServer.setPort(port);
        sshServer.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
        sshServer.setCommandFactory((CommandFactory)new ScpCommandFactory());
        sshServer.setKeyPairProvider(SFTPServer.createTestHostKeyProvider(Paths.get("hostkey.ser", new String[0])));
        sshServer.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                return StringUtils.equals((CharSequence)username, (CharSequence)SFTPServer.USERNAME) && StringUtils.equals((CharSequence)password, (CharSequence)CharBuffer.wrap(PASSWORD).toString());
            }
        });
        sshServer.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
        try {
            sshServer.start();
        }
        catch (IOException e) {
            this.log.error((Object)("Exception occurred " + e));
        }
        this.log.info((Object)("SFTP Server Stared successfully on port " + port));
        while (isKeepAlive) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                this.log.error((Object)("Exception occurred " + e));
            }
        }
    }

    public static KeyPairProvider createTestHostKeyProvider(Path path) {
        SimpleGeneratorHostKeyProvider keyProvider = new SimpleGeneratorHostKeyProvider();
        keyProvider.setPath((Path)ValidateUtils.checkNotNull((Object)path, (String)"No path"));
        keyProvider.setAlgorithm(DEFAULT_TEST_HOST_KEY_PROVIDER_ALGORITHM);
        return keyProvider;
    }

    public void stopServer() throws InterruptedException {
        try {
            sshServer.stop();
            this.log.info((Object)("SFTP Server Run On Port " + port + " Stopped successfully ..... "));
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to stop the SFTP server", (Throwable)e);
        }
    }
}

