/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.tomcatserver;

import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.wso2.carbon.automation.extensions.ExtensionUtils;
import org.wso2.carbon.automation.extensions.servers.tomcatserver.TomcatServerType;

public class TomcatServerManager {
    private static final Log log = LogFactory.getLog(TomcatServerManager.class);
    Tomcat tomcat;
    boolean isRunning = false;
    int tomcatPort;
    String tomcatClass = null;
    String basedir = null;
    String serverType;
    String webappDirLocation;
    private Thread tomcatThread = null;

    public TomcatServerManager(String className, String server, int port) {
        this.tomcatPort = port;
        this.tomcatClass = className;
        this.serverType = server;
        this.basedir = ExtensionUtils.getReportLocation();
    }

    public TomcatServerManager(String className, String server, int port, String webAppDir) {
        this.tomcatPort = port;
        this.tomcatClass = className;
        this.serverType = server;
        this.webappDirLocation = webAppDir;
    }

    public void startJaxRsServer() throws LifecycleException, IOException {
        File base = this.createBaseDirectory(this.basedir);
        log.info((Object)("Using base folder: " + base.getAbsolutePath()));
        this.tomcat = new Tomcat();
        this.tomcat.setPort(this.tomcatPort);
        this.tomcat.setBaseDir(base.getAbsolutePath());
        Context context = this.tomcat.addContext("/", base.getAbsolutePath());
        Tomcat.addServlet((Context)context, (String)"CXFServlet", (Servlet)new CXFServlet());
        context.addServletMapping("/rest/*", "CXFServlet");
        context.addApplicationListener(ContextLoaderListener.class.getName());
        context.setLoader((Loader)new WebappLoader(Thread.currentThread().getContextClassLoader()));
        context.addParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        context.addParameter("contextConfigLocation", this.tomcatClass);
        this.tomcat.start();
        this.tomcat.getServer().await();
    }

    public void startWebAppServer() throws ServletException, LifecycleException {
        String webPort = String.valueOf(this.tomcatPort);
        if (webPort == null || webPort.isEmpty()) {
            webPort = "8080";
        }
        this.tomcat.setPort(Integer.parseInt(webPort));
        this.tomcat.addWebapp("/", new File(this.webappDirLocation).getAbsolutePath());
        System.out.println("configuring app with basedir: " + new File("./" + this.webappDirLocation).getAbsolutePath());
        this.tomcat.start();
        this.tomcat.getServer().await();
    }

    public synchronized void startServer() {
        if (this.tomcatThread == null) {
            this.tomcatThread = new Thread(){

                @Override
                public void run() {
                    try {
                        if (TomcatServerManager.this.serverType.equals(TomcatServerType.jaxrs.name())) {
                            TomcatServerManager.this.startJaxRsServer();
                        } else if (TomcatServerManager.this.serverType.equals(TomcatServerType.webapp.name())) {
                            TomcatServerManager.this.startWebAppServer();
                        }
                    }
                    catch (IOException e) {
                        TomcatServerManager.this.handleException(e);
                    }
                    catch (LifecycleException e) {
                        TomcatServerManager.this.handleException((Exception)((Object)e));
                    }
                    catch (ServletException e) {
                        TomcatServerManager.this.handleException((Exception)((Object)e));
                    }
                }
            };
            this.tomcatThread.start();
            this.isRunning = true;
        }
    }

    private void handleException(Exception e) {
        String msg = "Tomcat server startup failed";
        log.error((Object)"Tomcat server startup failed ", (Throwable)e);
        throw new IllegalStateException(msg, e);
    }

    private File createBaseDirectory(String basedirLocal) throws IOException {
        File base = File.createTempFile("jaxrs-tmp-", "", new File(basedirLocal));
        if (!base.delete()) {
            throw new IOException("Cannot (re)create base folder: " + base.getAbsolutePath());
        }
        if (!base.mkdir()) {
            throw new IOException("Cannot create base folder: " + base.getAbsolutePath());
        }
        return base;
    }

    public void stop() throws LifecycleException {
        if (!this.isRunning) {
            log.info((Object)("Tomcat server is running at the port " + this.tomcatPort));
            return;
        }
        this.tomcat.stop();
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void run() {
        try {
            if (this.serverType.equals(TomcatServerType.jaxrs.name())) {
                this.startJaxRsServer();
            } else if (this.serverType.equals(TomcatServerType.webapp.name())) {
                this.startWebAppServer();
            }
        }
        catch (Exception e) {
            log.error((Object)("Server startup failed :" + e.getMessage()));
        }
    }
}

