/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;

public class ClientConnectionUtil {
    private static final Log log = LogFactory.getLog(ClientConnectionUtil.class);
    private static final long TIMEOUT = 120000L;

    public static void waitForLogin(AutomationContext context) throws AutomationFrameworkException, XPathExpressionException {
        ClientConnectionUtil.waitForLogin(context.getContextUrls().getSecureServiceUrl(), context.getSuperTenant().getTenantAdmin());
    }

    public static void waitForLogin(String backendUrl, User userInfo) throws AutomationFrameworkException {
        String hostName;
        long startTime = System.currentTimeMillis();
        boolean loginSuccess = false;
        String superAdminName = userInfo.getUserName();
        String superAdminPassword = userInfo.getPassword();
        try {
            hostName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Can not retrieve machine IP address. Setting it to 127.0.0.1");
            hostName = "127.0.0.1";
        }
        while (System.currentTimeMillis() - startTime < 120000L && !loginSuccess) {
            log.info((Object)"Waiting for user login...");
            try {
                loginSuccess = ClientConnectionUtil.checkAuthenticationAdminService(ClientConnectionUtil.createPayLoad(superAdminName, superAdminPassword, hostName), backendUrl);
                if (loginSuccess) continue;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Login failed after server startup ", (Throwable)e);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!loginSuccess) {
            throw new AutomationFrameworkException("Login failed for user " + superAdminName + " while verifying server startup. Please make sure that server is up and running or user is a valid user");
        }
    }

    @Deprecated
    public static boolean sendAdminServiceRequest(OMElement payload, String endpointURL) {
        try {
            ServiceClient serviceClient = new ServiceClient();
            Options opts = new Options();
            opts.setTo(new EndpointReference(endpointURL + "/AuthenticationAdmin"));
            log.info((Object)endpointURL);
            opts.setAction("urn:login");
            serviceClient.setOptions(opts);
            OMElement result = serviceClient.sendReceive(payload);
            if (result.toString().contains("<ns:return>true</ns:return>")) {
                log.info((Object)"Login was successful..");
                String sessionCookie = (String)serviceClient.getServiceContext().getProperty("Cookie");
                log.info((Object)sessionCookie);
                return false;
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Unable to login as user..");
        }
        return true;
    }

    public static boolean checkAuthenticationAdminService(OMElement payload, String endpointURL) throws AutomationFrameworkException {
        try {
            ServiceClient serviceClient = new ServiceClient();
            Options opts = new Options();
            opts.setTo(new EndpointReference(endpointURL + "/AuthenticationAdmin"));
            log.info((Object)endpointURL);
            opts.setAction("urn:login");
            serviceClient.setOptions(opts);
            OMElement result = serviceClient.sendReceive(payload);
            if (result.toString().contains("<ns:return>true</ns:return>")) {
                log.info((Object)"Login was successful..");
                String sessionCookie = (String)serviceClient.getServiceContext().getProperty("Cookie");
                log.info((Object)sessionCookie);
                return true;
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Unable to login as user..");
            throw new AutomationFrameworkException("Unable to login as user..", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForPort(int port, long timeout, boolean verbose, String hostName) throws RuntimeException {
        long startTime = System.currentTimeMillis();
        boolean isPortOpen = false;
        while (!isPortOpen && System.currentTimeMillis() - startTime < timeout) {
            Socket socket = null;
            try {
                InetAddress address = InetAddress.getByName(hostName);
                socket = new Socket(address, port);
                isPortOpen = socket.isConnected();
                if (!isPortOpen) continue;
                if (verbose) {
                    log.info((Object)("Successfully connected to the server on port " + port));
                }
                return;
            }
            catch (IOException e) {
                if (verbose) {
                    log.info((Object)("Waiting until server starts on port " + port));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (socket == null || !socket.isConnected()) continue;
                    socket.close();
                }
                catch (IOException e) {
                    log.error((Object)"Can not close the socket with is used to check the server status ", (Throwable)e);
                }
            }
        }
        throw new RuntimeException("Port " + port + " is not open");
    }

    public static void waitForPort(int port, String hostName) {
        ClientConnectionUtil.waitForPort(port, 120000L, true, hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortOpen(int port) {
        Socket socket = null;
        boolean isPortOpen = false;
        try {
            InetAddress address = InetAddress.getLocalHost();
            socket = new Socket(address, port);
            isPortOpen = socket.isConnected();
            if (isPortOpen) {
                log.info((Object)("Successfully connected to the server on port " + port));
            }
        }
        catch (IOException e) {
            log.info((Object)("Port " + port + " is closed and available for use"));
            isPortOpen = false;
        }
        finally {
            try {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Can not close the socket with is used to check the server status ", (Throwable)e);
            }
        }
        return isPortOpen;
    }

    public static OMElement createPayLoad(String userNameOfAdmin, String passwordOfAdmin, String hostName) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://authentication.services.core.carbon.wso2.org", "aut");
        OMElement loginRoot = fac.createOMElement("login", omNs);
        OMElement username = fac.createOMElement("username", omNs);
        OMElement password = fac.createOMElement("password", omNs);
        OMElement remoteAddress = fac.createOMElement("remoteAddress", omNs);
        username.setText(userNameOfAdmin);
        password.setText(passwordOfAdmin);
        remoteAddress.setText(hostName);
        loginRoot.addChild((OMNode)username);
        loginRoot.addChild((OMNode)password);
        loginRoot.addChild((OMNode)remoteAddress);
        return loginRoot;
    }

    public static void sendForcefulShutDownRequest(String backendURL, String userName, String password) throws AutomationFrameworkException {
        try {
            ServiceClient serviceClient = new ServiceClient();
            Options opts = new Options();
            opts.setManageSession(true);
            opts.setTo(new EndpointReference(backendURL + "ServerAdmin"));
            opts.setAction("urn:shutdown");
            HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
            auth.setUsername(userName);
            auth.setPassword(password);
            opts.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
            serviceClient.setOptions(opts);
            serviceClient.sendReceive(ClientConnectionUtil.createPayLoadShutDownServerForcefully());
        }
        catch (AxisFault e) {
            log.error((Object)"Unable to shutdown carbon server forcefully..", (Throwable)e);
            throw new AutomationFrameworkException("Unable to shutdown carbon server forcefully..", (Throwable)e);
        }
    }

    public static void sendGraceFullRestartRequest(String backendURL, String userName, String password) throws AutomationFrameworkException {
        try {
            ServiceClient serviceClient = new ServiceClient();
            Options opts = new Options();
            opts.setManageSession(true);
            opts.setTo(new EndpointReference(backendURL + "/ServerAdmin"));
            opts.setAction("urn:restart");
            HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
            auth.setUsername(userName);
            auth.setPassword(password);
            opts.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
            serviceClient.setOptions(opts);
            serviceClient.sendReceive(ClientConnectionUtil.createPayLoadRestartServerGracefully());
        }
        catch (AxisFault e) {
            log.error((Object)"Unable to restart carbon server gracefully..", (Throwable)e);
            throw new AutomationFrameworkException("Unable to restart carbon server gracefully..", (Throwable)e);
        }
    }

    public static OMElement createPayLoadShutDownServerForcefully() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://org.apache.axis2/xsd", "xsd");
        return fac.createOMElement("shutdown", omNs);
    }

    public static OMElement createPayLoadRestartServerGracefully() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://org.apache.axis2/xsd", "xsd");
        return fac.createOMElement("restart", omNs);
    }
}

