/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.common;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.wso2.carbon.automation.test.utils.common.EmailPasswordAuthenticator;

public class EmailSender {
    private Properties properties;
    private String recipientMail;
    private String senderId;
    private String username;
    private String password;
    private Session session;
    private String subject;
    private String body;
    private List<String> attachmentList = null;

    public EmailSender(Properties properties, String username, String password, String domainName, String recipientMail) {
        this.properties = properties;
        this.senderId = username + "@" + domainName;
        this.password = password;
        this.username = username;
        this.recipientMail = recipientMail;
    }

    public boolean createSession() {
        EmailPasswordAuthenticator authenticator = new EmailPasswordAuthenticator(this.username, this.password);
        this.session = Session.getInstance((Properties)this.properties, (Authenticator)authenticator);
        return this.session != null;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setAttachmentList(List<String> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public void sendEmail() throws MessagingException {
        Transport transport = this.session.getTransport("smtp");
        transport.connect();
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(this.senderId));
        InternetAddress[] address = new InternetAddress[]{new InternetAddress(this.recipientMail)};
        message.setRecipients(Message.RecipientType.TO, (Address[])address);
        message.setSubject(this.subject);
        message.setSentDate(new Date());
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setText(this.body);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)bodyPart);
        if (this.attachmentList != null) {
            for (String attachment : this.attachmentList) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(attachment);
                attachmentPart.setDataHandler(new DataHandler((DataSource)fds));
                attachmentPart.setFileName(fds.getName());
                multipart.addBodyPart((BodyPart)attachmentPart);
            }
        }
        message.setContent((Multipart)multipart);
        message.saveChanges();
        transport.sendMessage((Message)message, (Address[])address);
        transport.close();
    }
}

