/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.common.WireMonitorServer;

class WireMonitor
extends Thread {
    private Log log = LogFactory.getLog(WireMonitor.class);
    private int port;
    private ServerSocket providerSocket;
    private Socket connection = null;
    private WireMonitorServer trigger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream in = null;
        OutputStream out = null;
        try {
            int ch;
            this.providerSocket = new ServerSocket(this.port, 10);
            this.log.info((Object)"Waiting for connection");
            this.connection = this.providerSocket.accept();
            this.log.info((Object)("Connection received from " + this.connection.getInetAddress().getHostName()));
            in = this.connection.getInputStream();
            StringBuffer buffer = new StringBuffer();
            StringBuffer headerBuffer = new StringBuffer();
            Long time = System.currentTimeMillis();
            int contentLength = -1;
            while ((ch = in.read()) != -1) {
                this.log.debug((Object)("Character > " + (char)ch));
                buffer.append((char)ch);
                if (contentLength == -1 && buffer.toString().endsWith("\r\n\r\n")) {
                    headerBuffer = new StringBuffer(buffer.toString());
                    if (buffer.toString().contains("Content-Length")) {
                        String headers = buffer.toString();
                        String contentLengthHeader = headers.substring(headers.indexOf("Content-Length:"));
                        contentLengthHeader = contentLengthHeader.substring(0, contentLengthHeader.indexOf("\r\n"));
                        contentLength = Integer.parseInt(contentLengthHeader.split(":")[1].trim());
                        this.log.debug((Object)("Content-Length > " + contentLength));
                        buffer.setLength(0);
                    }
                }
                if (buffer.toString().length() != contentLength && System.currentTimeMillis() <= time + (long)this.trigger.READ_TIME_OUT && !buffer.toString().contains("</soapenv:Envelope>")) continue;
            }
            this.trigger.response = headerBuffer.toString() + buffer.toString();
            this.log.info((Object)"Wire Message received");
            this.log.info((Object)("Wire Message > " + this.trigger.response));
            this.trigger.setFinished(true);
            out = this.connection.getOutputStream();
            out.write("HTTP/1.1 202 Accepted\r\n\r\n".getBytes(Charset.defaultCharset()));
            out.flush();
        }
        catch (IOException ioException) {
            this.log.error((Object)ioException);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                this.connection.close();
                this.providerSocket.close();
            }
            catch (Exception e) {
                this.log.warn((Object)("Error while closing the connections" + e.getMessage()));
            }
        }
    }

    public WireMonitor(int listenPort, WireMonitorServer trigger) {
        this.port = listenPort;
        this.trigger = trigger;
    }
}

