/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.concurrency.test;

import java.util.Calendar;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.axis2client.AxisServiceClient;
import org.wso2.carbon.automation.test.utils.concurrency.test.exception.ConcurrencyTestFailedError;
import org.wso2.carbon.automation.test.utils.concurrency.test.exception.ExceptionHandler;

public class ConcurrencyTest {
    private static final Log log = LogFactory.getLog(ConcurrencyTest.class);
    private int concurrencyNumber;
    private int numberOfIterations;
    private Queue<OMElement> messageQueue;
    private Queue<AxisFault> errorQueue;

    public ConcurrencyTest(int threadGroup, int loopCount) {
        this.concurrencyNumber = threadGroup;
        this.numberOfIterations = loopCount;
        this.messageQueue = new LinkedList<OMElement>();
        this.errorQueue = new LinkedList<AxisFault>();
    }

    public Queue<OMElement> getMessages() {
        return this.messageQueue;
    }

    public void clearQueue() {
        this.messageQueue.clear();
    }

    public Queue<AxisFault> getErrorMessages() {
        return this.errorQueue;
    }

    public void clearErrorQueue() {
        this.errorQueue.clear();
    }

    public void run(final String serviceEndPoint, final OMElement payload, final String operation) throws ConcurrencyTestFailedError, InterruptedException {
        int i;
        log.info((Object)("Starting Concurrency test with " + this.concurrencyNumber + " Threads and " + this.numberOfIterations + " loop count"));
        this.clearQueue();
        this.clearErrorQueue();
        final ExceptionHandler handler = new ExceptionHandler();
        Thread[] clientThread = new Thread[this.concurrencyNumber];
        final AxisServiceClient serviceClient = new AxisServiceClient();
        for (i = 0; i < this.concurrencyNumber; ++i) {
            clientThread[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < ConcurrencyTest.this.numberOfIterations; ++j) {
                        try {
                            ConcurrencyTest.this.addToMessageQueue(serviceClient.sendReceive(payload.cloneOMElement(), serviceEndPoint, operation));
                            continue;
                        }
                        catch (AxisFault axisFault) {
                            handler.setException(axisFault);
                            ConcurrencyTest.this.addToErrorQueue(axisFault);
                        }
                    }
                }
            });
            clientThread[i].setUncaughtExceptionHandler(handler);
        }
        for (i = 0; i < this.concurrencyNumber; ++i) {
            clientThread[i].start();
        }
        int aliveCount = 0;
        Calendar startTime = Calendar.getInstance();
        while (aliveCount < this.concurrencyNumber && Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis() <= 120000L) {
            if (clientThread[aliveCount].isAlive()) {
                aliveCount = 0;
                continue;
            }
            ++aliveCount;
        }
        if (!handler.isTestPass()) {
            throw new ConcurrencyTestFailedError(handler.getFailCount() + " service invocation/s failed out of " + this.concurrencyNumber * this.numberOfIterations + " service invocations.\nConcurrency Test Failed for Thread Group=" + this.concurrencyNumber + " and loop count=" + this.numberOfIterations, handler.getException());
        }
    }

    private synchronized void addToMessageQueue(OMElement response) {
        this.messageQueue.add(response);
    }

    private synchronized void addToErrorQueue(AxisFault fault) {
        this.errorQueue.add(fault);
    }
}

