/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.dbutils;

import java.sql.SQLException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.configurations.AutomationConfiguration;
import org.wso2.carbon.automation.test.utils.dbutils.DatabaseManager;
import org.wso2.carbon.automation.test.utils.dbutils.SqlDatabaseManager;

public class DatabaseFactory {
    private static final Log log = LogFactory.getLog(DatabaseFactory.class);
    private static String JDBC_URL;
    private static String JDBC_DRIVER;
    private static String DB_USER;
    private static String DB_PASSWORD;

    private static void init() throws XPathExpressionException {
        JDBC_URL = AutomationConfiguration.getConfigurationValue((String)"//datasources/datasource/url");
        JDBC_DRIVER = AutomationConfiguration.getConfigurationValue((String)"//datasources/datasource/driverClassName");
        DB_USER = AutomationConfiguration.getConfigurationValue((String)"//datasources/datasource/username");
        DB_PASSWORD = AutomationConfiguration.getConfigurationValue((String)"//datasources/datasource/password");
    }

    public static DatabaseManager getDatabaseConnector(String databaseDriver, String jdbcUrl, String userName, String passWord) throws ClassNotFoundException, SQLException, XPathExpressionException {
        return new SqlDatabaseManager(databaseDriver, jdbcUrl, userName, passWord);
    }

    public static DatabaseManager getDatabaseConnector(String jdbcUrl, String userName, String passWord) throws ClassNotFoundException, SQLException, XPathExpressionException {
        DatabaseFactory.init();
        return new SqlDatabaseManager(JDBC_DRIVER, jdbcUrl, userName, passWord);
    }

    public static DatabaseManager getDatabaseConnector() throws ClassNotFoundException, SQLException, XPathExpressionException {
        DatabaseFactory.init();
        return new SqlDatabaseManager(JDBC_DRIVER, JDBC_URL, DB_USER, DB_PASSWORD);
    }
}

