/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.dbutils;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.dbutils.DatabaseManager;

public class OracleDatabaseManager
implements DatabaseManager {
    private static final Log log = LogFactory.getLog(OracleDatabaseManager.class);
    private Connection connection;

    public OracleDatabaseManager(String jdbcUrl, String userName, String passWord) throws SQLException, ClassNotFoundException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        log.debug((Object)("JDBC Url: " + jdbcUrl));
        this.connection = DriverManager.getConnection(jdbcUrl, userName, passWord);
        log.info((Object)"Connected to database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUpdate(String sql) throws SQLException {
        Statement st = null;
        try {
            st = this.connection.createStatement();
            log.debug((Object)sql);
            st.executeUpdate(sql.trim());
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        log.debug((Object)"Sql update Success");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUpdate(File sqlFile) throws SQLException, IOException {
        Statement st = null;
        String sql = FileManager.readFile(sqlFile).trim();
        log.debug((Object)("Query List:" + sql));
        String[] sqlQuery = sql.split(";");
        try {
            st = this.connection.createStatement();
            for (String query : sqlQuery) {
                log.debug((Object)query);
                st.executeUpdate(query.trim());
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        log.debug((Object)"Sql execution Success");
    }

    @Override
    public Statement getStatement(String sql) throws SQLException {
        return this.connection.createStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs;
        Statement st = null;
        try {
            st = this.connection.createStatement();
            log.debug((Object)sql);
            rs = st.executeQuery(sql);
        }
        finally {
            assert (st != null);
            st.close();
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String sql) throws SQLException {
        Statement st = null;
        try {
            st = this.connection.createStatement();
            st.execute(sql);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        log.debug((Object)"Sql execution Success");
    }

    @Override
    public void disconnect() throws SQLException {
        this.connection.close();
        log.info((Object)"Disconnected from database");
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.connection.isClosed()) {
                this.disconnect();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error while disconnecting from database");
            throw new SQLException("Error while disconnecting from database");
        }
        super.finalize();
    }
}

