/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;

public class HttpClientUtil {
    private static final Log log = LogFactory.getLog(HttpClientUtil.class);
    private static final int connectionTimeOut = 30000;

    public OMElement get(String endpoint) throws AutomationFrameworkException {
        log.info((Object)("Endpoint : " + endpoint));
        HttpURLConnection httpCon = null;
        String xmlContent = null;
        int responseCode = -1;
        try {
            URL url = new URL(endpoint);
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setConnectTimeout(30000);
            InputStream in = httpCon.getInputStream();
            xmlContent = HttpClientUtil.getStringFromInputStream(in);
            responseCode = httpCon.getResponseCode();
            in.close();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
        }
        Assert.assertEquals((int)responseCode, (int)200, (String)"Response code not 200");
        try {
            return AXIOMUtil.stringToOM((String)xmlContent);
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while processing response to OMElement" + e));
            throw new AutomationFrameworkException("Error while processing response to OMElement", (Throwable)e);
        }
    }

    public OMElement getWithContentType(String endpoint, String params, String contentType) throws AutomationFrameworkException {
        log.info((Object)("Endpoint : " + endpoint));
        HttpURLConnection httpCon = null;
        String xmlContent = null;
        int responseCode = -1;
        try {
            URL url = new URL(endpoint);
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setConnectTimeout(30000);
            httpCon.setRequestProperty("Content-type", contentType);
            httpCon.setRequestMethod("GET");
            httpCon.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream(), Charset.defaultCharset());
            out.write(params);
            out.close();
            InputStream in = httpCon.getInputStream();
            xmlContent = HttpClientUtil.getStringFromInputStream(in);
            responseCode = httpCon.getResponseCode();
            in.close();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (ProtocolException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
        }
        Assert.assertEquals((int)responseCode, (int)200, (String)"Response code not 200");
        try {
            return AXIOMUtil.stringToOM((String)xmlContent);
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while processing response to OMElement" + e));
            throw new AutomationFrameworkException("Error while processing response to OMElement" + e);
        }
    }

    public void delete(String endpoint, String params) throws AutomationFrameworkException {
        log.info((Object)("Endpoint : " + endpoint));
        HttpURLConnection httpCon = null;
        int responseCode = -1;
        try {
            URL url = new URL(endpoint + "?" + params);
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setConnectTimeout(30000);
            httpCon.setRequestMethod("DELETE");
            responseCode = httpCon.getResponseCode();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (ProtocolException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
        }
        Assert.assertEquals((int)responseCode, (int)202, (String)"Response Code not 202");
    }

    public void post(String endpoint, String params) throws AutomationFrameworkException {
        log.info((Object)("Endpoint : " + endpoint));
        HttpURLConnection httpCon = null;
        int responseCode = -1;
        try {
            URL url = new URL(endpoint);
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setConnectTimeout(30000);
            httpCon.setDoOutput(true);
            httpCon.setRequestMethod("POST");
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream(), Charset.defaultCharset());
            out.write(params);
            out.close();
            responseCode = httpCon.getResponseCode();
            httpCon.getInputStream().close();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (ProtocolException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
        }
        Assert.assertEquals((int)responseCode, (int)202, (String)"Response Code not 202");
    }

    public int postWithContentType(String endpoint, String params, String contentType) throws AutomationFrameworkException {
        log.info((Object)("Endpoint : " + endpoint));
        HttpURLConnection httpCon = null;
        int responseCode = -1;
        try {
            URL url = new URL(endpoint);
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setConnectTimeout(30000);
            httpCon.setDoOutput(true);
            httpCon.setRequestMethod("POST");
            httpCon.setRequestProperty("Content-type", contentType);
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream(), Charset.defaultCharset());
            out.write(params);
            out.close();
            responseCode = httpCon.getResponseCode();
            httpCon.getInputStream().close();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (ProtocolException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
        }
        return responseCode;
    }

    public void put(String endpoint, String params) throws AutomationFrameworkException {
        log.info((Object)("Endpoint : " + endpoint));
        HttpURLConnection httpCon = null;
        int responseCode = -1;
        try {
            URL url = new URL(endpoint);
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setConnectTimeout(30000);
            httpCon.setDoOutput(true);
            httpCon.setRequestMethod("PUT");
            httpCon.setRequestProperty("Content-Length", String.valueOf(params.length()));
            httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream(), Charset.defaultCharset());
            out.write(params);
            out.close();
            responseCode = httpCon.getResponseCode();
            httpCon.getInputStream().close();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (ProtocolException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
        }
        Assert.assertEquals((int)responseCode, (int)202, (String)"Response Code not 202");
    }

    public void patch(String endpoint, String params) throws AutomationFrameworkException {
        log.info((Object)("Endpoint : " + endpoint));
        HttpURLConnection httpCon = null;
        int responseCode = -1;
        try {
            URL url = new URL(endpoint);
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setConnectTimeout(30000);
            httpCon.setDoOutput(true);
            httpCon.setRequestMethod("PUT");
            httpCon.setRequestProperty("Content-Length", String.valueOf(params.length()));
            httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            httpCon.setRequestProperty("X-HTTP-Method-Override", "PATCH");
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream(), Charset.defaultCharset());
            out.write(params);
            out.close();
            responseCode = httpCon.getResponseCode();
            httpCon.getInputStream().close();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (ProtocolException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new AutomationFrameworkException("Failed to get the response :" + e);
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
        }
        Assert.assertEquals((int)responseCode, (int)202, (String)"Response Code not 202");
    }

    private static String getStringFromInputStream(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, Charset.defaultCharset());
        char[] buff = new char[1024];
        StringBuffer retValue = new StringBuffer();
        try {
            int i;
            while ((i = reader.read(buff)) > 0) {
                retValue.append(new String(buff, 0, i));
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to get the response " + e));
            throw new IOException("Failed to get the response :" + e);
        }
        return retValue.toString();
    }
}

