/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.tcpmon.client;

import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.tcpmon.client.Connection;
import org.wso2.carbon.automation.test.utils.tcpmon.client.TCPMonListener;

class SocketWaiter
extends Thread {
    private static final Log log = LogFactory.getLog(SocketWaiter.class);
    private ServerSocket sSocket = null;
    private TCPMonListener listener;
    private int listenPort;
    private boolean pleaseStop = false;

    public SocketWaiter(TCPMonListener listener, int listenPort) {
        this.listener = listener;
        this.listenPort = listenPort;
        this.start();
    }

    @Override
    public void run() {
        block4: {
            try {
                log.info((Object)"waiting for connection....");
                this.sSocket = new ServerSocket(this.listenPort);
                while (true) {
                    Socket inSocket = this.sSocket.accept();
                    if (!this.pleaseStop) {
                        new Connection(this.listener, inSocket);
                        inSocket = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                if ("socket closed".equals(exp.getMessage())) break block4;
                this.listener.stop();
            }
        }
    }

    public void halt() {
        try {
            this.pleaseStop = true;
            new Socket("127.0.0.1", this.listenPort);
            if (this.sSocket != null) {
                this.sSocket.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while closing socket : " + e.getMessage()));
        }
    }
}

