/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileManager {
    private static final Log log = LogFactory.getLog(FileManager.class);

    public static String readFile(String filePath) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), Charset.defaultCharset()));
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }

    public static String readFile(File file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String filePath, String content) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, true), Charset.defaultCharset()));
        try {
            writer.write(content);
            writer.newLine();
            writer.flush();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, String destinationPath) throws IOException {
        File destinationFile = new File(destinationPath);
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(sourceFile), Charset.defaultCharset());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destinationFile), Charset.defaultCharset()));
        try {
            int c;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyResourceToFileSystem(String sourcePath, String targetPath, String fileName) throws IOException {
        File file = new File(targetPath + File.separator + fileName);
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        FileUtils.touch((File)file);
        FileOutputStream os = FileUtils.openOutputStream((File)file);
        FileInputStream is = new FileInputStream(sourcePath);
        try {
            int len;
            byte[] data = new byte[1024];
            while ((len = ((InputStream)is).read(data)) != -1) {
                ((OutputStream)os).write(data, 0, len);
                os.flush();
            }
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (IOException iOException) {}
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyJarFile(String sourceFileLocationWithFileName, String destinationDirectory) throws IOException, URISyntaxException {
        File sourceFile = new File(this.getClass().getResource(sourceFileLocationWithFileName).toURI());
        File destinationFileDirectory = new File(destinationDirectory);
        JarFile jarFile = new JarFile(sourceFile);
        String fileName = jarFile.getName();
        String fileNameLastPart = fileName.substring(fileName.lastIndexOf(File.separator));
        File destinationFile = new File(destinationFileDirectory, fileNameLastPart);
        ZipOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(destinationFile));
            Enumeration<JarEntry> entries = jarFile.entries();
            InputStream inputStream = null;
            while (entries.hasMoreElements()) {
                try {
                    JarEntry jarEntry = entries.nextElement();
                    inputStream = jarFile.getInputStream(jarEntry);
                    ((JarOutputStream)jarOutputStream).putNextEntry(new JarEntry(jarEntry.getName()));
                    byte[] buffer = new byte[4096];
                    int bytesRead = 0;
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        jarOutputStream.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                    jarOutputStream.flush();
                    jarOutputStream.closeEntry();
                }
            }
        }
        finally {
            if (jarOutputStream != null) {
                jarOutputStream.close();
            }
            jarFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyJarFile(File sourceFile, String destinationDirectory) throws IOException {
        File destinationFileDirectory = new File(destinationDirectory);
        JarFile jarFile = new JarFile(sourceFile);
        String fileName = jarFile.getName();
        String fileNameLastPart = fileName.substring(fileName.lastIndexOf(File.separator));
        File destinationFile = new File(destinationFileDirectory, fileNameLastPart);
        ZipOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(destinationFile));
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                ((JarOutputStream)jarOutputStream).putNextEntry(new JarEntry(jarEntry.getName()));
                byte[] buffer = new byte[4096];
                int bytesRead = 0;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    jarOutputStream.write(buffer, 0, bytesRead);
                }
                inputStream.close();
                jarOutputStream.flush();
                jarOutputStream.closeEntry();
            }
        }
        finally {
            if (jarOutputStream != null) {
                try {
                    jarOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            jarFile.close();
        }
    }

    public static boolean deleteFile(String filePathWithFileName) {
        File jarFile = new File(filePathWithFileName);
        return !jarFile.isDirectory() && jarFile.delete();
    }
}

