/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.dbutils;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.dbutils.DatabaseManager;

public class DerbyDatabaseManager
implements DatabaseManager {
    private static final Log log = LogFactory.getLog(DerbyDatabaseManager.class);
    private Statement stmt = null;
    private Connection dbConnection = null;

    public DerbyDatabaseManager(String jdbcURL) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        String driverClass = "org.apache.derby.jdbc.ClientDriver";
        Class.forName(driverClass).newInstance();
        this.dbConnection = DriverManager.getConnection(jdbcURL);
    }

    public DerbyDatabaseManager(String jdbcURL, String userName, String passWord) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        String driverClass = "org.apache.derby.jdbc.ClientDriver";
        Class.forName(driverClass).newInstance();
        this.dbConnection = DriverManager.getConnection(jdbcURL, userName, passWord);
    }

    public void setAutoCommit() throws SQLException {
        this.dbConnection.setAutoCommit(false);
        this.dbConnection.commit();
    }

    @Override
    public void executeUpdate(String sql) throws SQLException {
        this.stmt = this.dbConnection.createStatement();
        this.stmt.executeUpdate(sql);
        this.stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUpdate(File sqlFile) throws SQLException, IOException {
        Statement st = null;
        String sql = FileManager.readFile(sqlFile).trim();
        log.debug((Object)("Query List:" + sql));
        String[] sqlQuery = sql.split(";");
        try {
            st = this.dbConnection.createStatement();
            for (String query : sqlQuery) {
                log.debug((Object)query);
                st.executeUpdate(query.trim());
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        log.debug((Object)"Sql execution Success");
    }

    @Override
    public ResultSet executeQuery(String sqlQuery) throws SQLException {
        this.stmt = this.dbConnection.createStatement();
        ResultSet resultSet = this.stmt.executeQuery(sqlQuery);
        this.stmt.close();
        return resultSet;
    }

    @Override
    public void execute(String sql) throws SQLException {
        this.stmt = this.dbConnection.createStatement();
        this.stmt.execute(sql);
        this.stmt.close();
    }

    @Override
    public Statement getStatement(String sql) throws SQLException {
        return this.dbConnection.createStatement();
    }

    @Override
    public void disconnect() throws SQLException {
        this.dbConnection.close();
        log.debug((Object)"Disconnected from database");
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.dbConnection.isClosed()) {
                this.disconnect();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error while disconnecting from database");
            throw new SQLException("Error while disconnecting from database");
        }
        super.finalize();
    }
}

