/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.generic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;

public class GenericJSONClient {
    public static final Log log = LogFactory.getLog(GenericJSONClient.class);
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";

    public JSONObject doGet(String endpoint, String query, String contentType) throws AutomationFrameworkException, IOException {
        String charset = "UTF-8";
        OutputStream os = null;
        InputStream is = null;
        try {
            if (contentType == null || "".equals(contentType)) {
                contentType = "application/json";
            }
            URLConnection conn = new URL(endpoint).openConnection();
            conn.setRequestProperty(HEADER_CONTENT_TYPE, contentType);
            conn.setRequestProperty(HEADER_ACCEPT_CHARSET, charset);
            conn.setRequestProperty("Content-Length", "1000");
            conn.setReadTimeout(30000);
            System.setProperty("java.net.preferIPv4Stack", "true");
            conn.setRequestProperty("Connection", "close");
            conn.setDoOutput(true);
            os = conn.getOutputStream();
            os.write(query.getBytes(charset));
            is = conn.getInputStream();
            String out = null;
            if (is != null) {
                int len;
                StringBuilder source = new StringBuilder();
                byte[] data = new byte[1024];
                while ((len = is.read(data)) != -1) {
                    source.append(new String(data, 0, len, Charset.defaultCharset()));
                }
                out = source.toString();
            }
            JSONObject jSONObject = new JSONObject(out);
            return jSONObject;
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Error occurred while executing the GET operation", (Throwable)e);
        }
        catch (JSONException e) {
            throw new AutomationFrameworkException("Error occurred while parsing the response to a JSONObject", (Throwable)e);
        }
        finally {
            assert (os != null);
            os.flush();
            os.close();
            assert (is != null);
            is.close();
        }
    }

    public void doPost(String endpoint, String queryString, String contentType) throws AutomationFrameworkException {
        String charset = "UTF-8";
        try {
            if (contentType == null || "".equals(contentType)) {
                contentType = "application/json";
            }
            HttpURLConnection conn = (HttpURLConnection)new URL(endpoint).openConnection();
            conn.setRequestProperty(HEADER_CONTENT_TYPE, contentType);
            conn.setRequestProperty(HEADER_ACCEPT_CHARSET, charset);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(queryString.getBytes(charset));
            os.flush();
            os.close();
            int responseCode = conn.getResponseCode();
            conn.getInputStream().close();
            if (responseCode != 202) {
                throw new AutomationFrameworkException("Server responded with an inappropriate response code : '" + responseCode + "'");
            }
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Error occurred while executing the GET operation", (Throwable)e);
        }
    }
}

